/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Date;

public class DecisionTime {
    static final String UNSIGNED_KEY = "ssv.decision.unsigned.time";
    static final String SASIGNED_KEY = "ssv.decision.sandbox.time";
    static final String ALSIGNED_KEY = "ssv.decision.all-perms.time";
    private static final String APP_HASH_KEY = "ssv.decision.app.hash";
    private static final String CERT_HASH_KEY = "ssv.decision.cert.hash";
    private static final String URL_BASE_KEY = "ssv.decision.base";
    private static final long ONEDAY = 86400000L;

    public static void reset(LocalApplicationProperties localApplicationProperties) {
        if (localApplicationProperties != null) {
            localApplicationProperties.put(UNSIGNED_KEY, null);
            localApplicationProperties.put(SASIGNED_KEY, null);
            localApplicationProperties.put(ALSIGNED_KEY, null);
            localApplicationProperties.put(URL_BASE_KEY, null);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
    }

    protected static boolean withinTime(URL uRL, AppInfo appInfo, X509Certificate x509Certificate, String string) {
        boolean bl = !SecurityBaseline.isExpired();
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties(appInfo.getLapURL());
        if (bl && localApplicationProperties != null) {
            String string2 = localApplicationProperties.get(string);
            String string3 = localApplicationProperties.get(APP_HASH_KEY);
            if (string2 != null && string3 != null) {
                try {
                    long l = new Long(string2);
                    long l2 = new Date().getTime();
                    if (l > l2) {
                        if (string3.equals(appInfo.getHashString()) && DecisionTime.sameBase(localApplicationProperties, uRL)) {
                            if (x509Certificate == null) {
                                return true;
                            }
                            String string4 = CertUtils.getCertificateFingerPrint("SHA-256", x509Certificate);
                            if (string4.equals(localApplicationProperties.get(CERT_HASH_KEY))) {
                                return true;
                            }
                            Trace.println("Decision cert hash not matching", TraceLevel.SECURITY);
                        } else {
                            Trace.println("Decision hash not matching ai: " + appInfo, TraceLevel.SECURITY);
                        }
                    } else {
                        Trace.println("Decision time exceeded - show dialog", TraceLevel.SECURITY);
                    }
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
            }
        }
        return false;
    }

    protected static void setTime(URL uRL, AppInfo appInfo, X509Certificate x509Certificate, String string) {
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties(appInfo.getLapURL());
        if (localApplicationProperties != null) {
            String string2;
            if (localApplicationProperties.get(URL_BASE_KEY) != null && !DecisionTime.sameBase(localApplicationProperties, uRL)) {
                return;
            }
            long l = new Date().getTime();
            URL uRL2 = appInfo.getFrom();
            if (uRL2 != null) {
                string2 = uRL2.getProtocol();
                l = "https".equals(string2) && !appInfo.isMultiHost() ? (l += 604800000L) : (l += 86400000L);
            }
            localApplicationProperties.put(string, "" + l);
            localApplicationProperties.put(APP_HASH_KEY, "" + appInfo.getHashString());
            localApplicationProperties.put(URL_BASE_KEY, uRL.toString());
            if (x509Certificate != null) {
                string2 = CertUtils.getCertificateFingerPrint("SHA-256", x509Certificate);
                localApplicationProperties.put(CERT_HASH_KEY, string2);
            }
            Trace.println("Decision time stored for ai: " + appInfo, TraceLevel.SECURITY);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        } else {
            Trace.println("Lap null for ai: " + appInfo, TraceLevel.SECURITY);
        }
    }

    private static boolean sameBase(LocalApplicationProperties localApplicationProperties, URL uRL) {
        String string;
        if (localApplicationProperties != null && uRL != null && (string = localApplicationProperties.get(URL_BASE_KEY)) != null) {
            try {
                URL uRL2 = new URL(string);
                if (URLUtil.sameBase(uRL2, uRL)) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
            }
        }
        return false;
    }
}

