/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLPermission;
import java.security.Permission;
import java.util.BitSet;
import java.util.WeakHashMap;

public class URLUtil {
    static BitSet encodedInPath = new BitSet(256);
    private static WeakHashMap canonicalizedURLMap;
    private static final ThreadLocal packURLOriginal;

    public static void setHostHeader(URLConnection uRLConnection) {
        int n = uRLConnection.getURL().getPort();
        String string = uRLConnection.getURL().getHost();
        if (n != -1 && n != 80) {
            string = string + ":" + String.valueOf(n);
        }
        uRLConnection.setRequestProperty("Host", string);
    }

    public static URL getBase(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getFile();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(0, n + 1);
            }
            try {
                return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
            }
        }
        return uRL;
    }

    public static boolean isUNCFileURL(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equalsIgnoreCase("file")) {
            return false;
        }
        String string = uRL.toString();
        string = string.replaceAll("////", "//");
        try {
            URL uRL2 = new URL(string);
            if (uRL2.getHost().equals("")) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static URL asPathURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getFile();
        if (string != null && !string.endsWith("/")) {
            try {
                return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static String toNormalizedString(URL uRL) {
        if (uRL == null) {
            return "";
        }
        try {
            uRL = uRL.getPort() == uRL.getDefaultPort() ? new URL(uRL.getProtocol().toLowerCase(), uRL.getHost().toLowerCase(), -1, uRL.getFile()) : new URL(uRL.getProtocol().toLowerCase(), uRL.getHost().toLowerCase(), uRL.getPort(), uRL.getFile());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL.toExternalForm();
    }

    public static boolean sameURLs(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null || uRL == uRL2) {
            return uRL == uRL2;
        }
        String string = uRL.getFile();
        String string2 = uRL2.getFile();
        return string.length() == string2.length() && URLUtil.sameBase(uRL, uRL2) && string.equalsIgnoreCase(string2);
    }

    public static boolean sameBase(URL uRL, URL uRL2) {
        return uRL != null && uRL2 != null && URLUtil.sameHost(uRL, uRL2) && URLUtil.samePort(uRL, uRL2) && URLUtil.sameProtocol(uRL, uRL2);
    }

    private static boolean sameProtocol(URL uRL, URL uRL2) {
        return uRL.getProtocol().equals(uRL2.getProtocol());
    }

    private static boolean sameHost(URL uRL, URL uRL2) {
        String string = uRL.getHost();
        String string2 = uRL2.getHost();
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        return string.length() == string2.length() && string.equalsIgnoreCase(string2);
    }

    private static boolean samePort(URL uRL, URL uRL2) {
        return URLUtil.getPort(uRL) == URLUtil.getPort(uRL2);
    }

    public static int getPort(URL uRL) {
        if (uRL.getPort() != -1) {
            return uRL.getPort();
        }
        return uRL.getDefaultPort();
    }

    public static String urlToLocation(URL uRL) {
        try {
            return uRL.getProtocol() + "//" + uRL.getHost().toLowerCase() + ":" + URLUtil.getPort(uRL);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            return null;
        }
    }

    public static String encodePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == File.separatorChar) {
                stringBuffer.append('/');
                continue;
            }
            if (c <= '\u007f') {
                if (encodedInPath.get(c)) {
                    URLUtil.escape(stringBuffer, c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c > '\u07ff') {
                URLUtil.escape(stringBuffer, (char)(0xE0 | c >> 12 & 0xF));
                URLUtil.escape(stringBuffer, (char)(0x80 | c >> 6 & 0x3F));
                URLUtil.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            URLUtil.escape(stringBuffer, (char)(0xC0 | c >> 6 & 0x1F));
            URLUtil.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
        }
        if (!string.equals(stringBuffer.toString())) {
            Trace.println("     String: " + string, TraceLevel.BASIC);
            Trace.println(" encoded to: " + stringBuffer.toString(), TraceLevel.BASIC);
        }
        return stringBuffer.toString();
    }

    private static void escape(StringBuffer stringBuffer, char c) {
        stringBuffer.append('%');
        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
        stringBuffer.append(Character.forDigit(c & 0xF, 16));
    }

    public static String decodePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c;
            block15: {
                c = string.charAt(n);
                if (c != '%') {
                    ++n;
                } else {
                    try {
                        c = URLUtil.unescape(string, n);
                        n += 3;
                        if ((c & 0x80) == 0) break block15;
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c2 = URLUtil.unescape(string, n);
                                if (c2 >> 6 != 2) {
                                    throw new SecurityException("Unexpected decoding error:");
                                }
                                n += 3;
                                if ((c = (char)((c & 0x1F) << 6 | c2 & 0x3F)) <= '\u007f') {
                                    throw new SecurityException("unsupported overlong encoding");
                                }
                                break;
                            }
                            case 14: {
                                char c2 = URLUtil.unescape(string, n);
                                if (c2 >> 6 != 2) {
                                    throw new SecurityException("Unexpected decoding error:");
                                }
                                char c3 = URLUtil.unescape(string, n += 3);
                                if (c3 >> 6 != 2) {
                                    throw new SecurityException("Unexpected decoding error:");
                                }
                                n += 3;
                                if ((c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F)) <= '\u007f') {
                                    throw new SecurityException("unsupported overlong encoding");
                                }
                                break;
                            }
                            default: {
                                throw new SecurityException("Unexpected decoding error:");
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SecurityException("Unexpected decoding error: " + string, numberFormatException);
                    }
                }
            }
            stringBuffer.append(c);
        }
        if (!string.equals(stringBuffer.toString())) {
            Trace.println("     String: " + string, TraceLevel.BASIC);
            Trace.println(" decoded to: " + stringBuffer.toString(), TraceLevel.BASIC);
        }
        return stringBuffer.toString();
    }

    private static char unescape(String string, int n) {
        return (char)Integer.parseInt(string.substring(n + 1, n + 3), 16);
    }

    public static String getEncodedPath(File file) {
        String string = file.getAbsolutePath();
        if (!string.endsWith(File.separator) && file.isDirectory()) {
            string = string + File.separator;
        }
        return URLUtil.encodePath(string);
    }

    public static String getDecodedPath(URL uRL) {
        String string = uRL.getFile();
        string = string.replace('/', File.separatorChar);
        return URLUtil.decodePath(string);
    }

    public static String getPathFromURL(URL uRL) {
        return URLUtil.getDecodedPath(uRL);
    }

    public static synchronized String canonicalize(String string) {
        if (string.indexOf("file:") == -1) {
            return string;
        }
        String string2 = (String)canonicalizedURLMap.get(string);
        if (string2 != null) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf("file://///") == 0) {
            stringBuffer.append("file:////");
            stringBuffer.append(string.substring(10));
        } else if (string.indexOf("file:///\\") == 0) {
            stringBuffer.append("file:////");
            stringBuffer.append(string.substring(9));
        } else if (string.indexOf("file://\\") == 0) {
            stringBuffer.append("file:////");
            stringBuffer.append(string.substring(9));
        } else if (string.indexOf("file:\\") == 0) {
            if (string.indexOf(58, 6) != -1 || string.indexOf(124, 6) != -1) {
                stringBuffer.append("file:///");
            } else {
                stringBuffer.append("file:////");
            }
            stringBuffer.append(string.substring(6));
        } else if (string.indexOf("file://") == 0 && string.charAt(7) != '/') {
            if (string.indexOf(58, 7) != -1 || string.indexOf(124, 7) != -1) {
                stringBuffer.append("file:///");
            } else {
                stringBuffer.append("file:////");
            }
            stringBuffer.append(string.substring(7));
        } else {
            stringBuffer.append(string);
        }
        boolean bl = false;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '\\') {
                stringBuffer.setCharAt(i, '/');
                continue;
            }
            if (bl || c != '|') continue;
            stringBuffer.setCharAt(i, ':');
            bl = true;
        }
        String string3 = stringBuffer.toString();
        canonicalizedURLMap.put(string, string3);
        return string3;
    }

    public static String canonicalizeDocumentBaseURL(String string) {
        int n = -1;
        int n2 = string.indexOf(35);
        int n3 = string.indexOf(63);
        if (n3 != -1 && n2 != -1) {
            n = Math.min(n2, n3);
        } else if (n2 != -1) {
            n = n2;
        } else if (n3 != -1) {
            n = n3;
        }
        String string2 = n == -1 ? string : string.substring(0, n);
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n4 = stringBuffer.toString().indexOf("|");
        if (n4 >= 0) {
            stringBuffer.setCharAt(n4, ':');
        }
        if (n != -1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private static String slashify(String string, boolean bl) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && bl) {
            string2 = string2 + "/";
        }
        return string2;
    }

    public static URL fileToURL(File file) {
        if (file == null) {
            return null;
        }
        if (Config.isJavaVersionAtLeast14()) {
            try {
                File file2 = file.getAbsoluteFile();
                String string = URLUtil.slashify(file2.getPath(), file2.isDirectory());
                if (string.startsWith("//")) {
                    string = "//" + string;
                }
                return new URI("file", null, string, null).toURL();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new Error(uRISyntaxException);
            }
            catch (MalformedURLException malformedURLException) {
                throw new Error(malformedURLException);
            }
        }
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error(malformedURLException);
        }
    }

    public static String urlNoFragString(URL uRL) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer(128);
        String string3 = uRL.getProtocol();
        if (string3 != null) {
            string3 = string3.toLowerCase();
            stringBuffer.append(string3);
            stringBuffer.append("://");
        }
        if ((string2 = uRL.getHost()) != null) {
            string2 = string2.toLowerCase();
            stringBuffer.append(string2);
            int n = uRL.getPort();
            if (n == -1) {
                try {
                    n = uRL.getDefaultPort();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    n = uRL.getPort();
                }
            }
            if (n != -1) {
                stringBuffer.append(":").append(n);
            }
        }
        if ((string = uRL.getFile()) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static boolean checkTargetURL(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return false;
        }
        if ("jar".equals(uRL.getProtocol())) {
            try {
                uRL = new URL(uRL.toString().substring(4));
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
                return false;
            }
        }
        if ("jar".equals(uRL2.getProtocol())) {
            try {
                uRL2 = new URL(uRL2.toString().substring(4));
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
                return false;
            }
        }
        if ("file".equals(uRL.getProtocol())) {
            boolean bl = URLUtil.isUNCFileURL(uRL);
            boolean bl2 = URLUtil.isUNCFileURL(uRL2);
            return !bl || bl2;
        }
        return !uRL2.getProtocol().equals("file") && !uRL2.getProtocol().equals("netdoc");
    }

    public static boolean checkDocumentURL(URL uRL, URL uRL2) throws SecurityException {
        Object object;
        if (URLUtil.checkTargetURL(uRL, uRL2)) {
            return true;
        }
        URL uRL3 = uRL2;
        boolean bl = false;
        if ("jar".equals(uRL2.getProtocol())) {
            try {
                uRL3 = new URL(uRL2.toString().substring(4));
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
                return bl;
            }
        }
        if ("file".equals(uRL3.getProtocol())) {
            try {
                object = new File(uRL3.getFile());
                ((File)object).canRead();
                bl = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (!bl) {
            object = ResourceManager.getMessage("show.document.denied");
            Trace.println((String)object, TraceLevel.SECURITY);
            throw new SecurityException((String)object);
        }
        return true;
    }

    public static URL getJarEntryURL(URL uRL, String string) throws MalformedURLException {
        return URLUtil.getJarEntryURL(uRL.toString(), string);
    }

    public static URL getJarEntryURL(String string, String string2) throws MalformedURLException {
        if (string2 == null) {
            throw new MalformedURLException("null entryName");
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return new URL("jar:" + string + "!" + string2);
    }

    public static URL getPack200URL(URL uRL, boolean bl) {
        URL uRL2 = null;
        if (uRL == null) {
            return null;
        }
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        String string3 = uRL.getPath();
        String string4 = uRL.getQuery();
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (!stringBuffer.toString().endsWith(".pack.gz")) {
            stringBuffer.append(".pack.gz");
        }
        if (string4 != null) {
            stringBuffer.append("?");
            stringBuffer.append(string4);
        }
        try {
            uRL2 = new URL(string, string2, n, stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
        }
        if (bl) {
            packURLOriginal.set(uRL);
        }
        return uRL2;
    }

    public static void clearPack200Original() {
        packURLOriginal.set(null);
    }

    public static URL getPack200Original() {
        return (URL)packURLOriginal.get();
    }

    public static Permission getConnectPermission(URL uRL) throws IOException {
        if (Config.isJavaVersionAtLeast18()) {
            String string = uRL.toString().toLowerCase();
            if (string.startsWith("http:") || string.startsWith("https:")) {
                return URLUtil.getURLConnectPermission(uRL);
            }
            if (string.startsWith("jar:http:") || string.startsWith("jar:https:")) {
                String string2;
                int n = (string2 = uRL.toString()).indexOf("!/");
                string2 = string2.substring(4, n > -1 ? n : string2.length());
                URL uRL2 = new URL(string2);
                return URLUtil.getURLConnectPermission(uRL2);
            }
            return uRL.openConnection().getPermission();
        }
        return uRL.openConnection().getPermission();
    }

    private static Permission getURLConnectPermission(URL uRL) {
        String string = uRL.getProtocol() + "://" + uRL.getAuthority() + uRL.getPath();
        return new URLPermission(string);
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
        canonicalizedURLMap = new WeakHashMap();
        packURLOriginal = new ThreadLocal();
    }
}

