/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.MapCreator;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.ObjectCreator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;
import jdk.nashorn.internal.scripts.JO;

public class SpillObjectCreator
extends ObjectCreator {
    private final List<Expression> values;

    protected SpillObjectCreator(CodeGenerator codegen, List<String> keys, List<Symbol> symbols, List<Expression> values) {
        super(codegen, keys, symbols, false, false);
        this.values = values;
        this.makeMap();
    }

    @Override
    protected void makeObject(MethodEmitter method) {
        assert (!this.isScope()) : "spill scope objects are not currently supported";
        int length = this.keys.size();
        Object[] presetValues = new Object[length];
        LinkedHashSet<Integer> postsetValues = new LinkedHashSet<Integer>();
        int callSiteFlags = this.codegen.getCallSiteFlags();
        ArrayData arrayData = ArrayData.allocate(new Object[0]);
        for (int i = 0; i < length; ++i) {
            String key = (String)this.keys.get(i);
            Expression value = this.values.get(i);
            if (value == null) continue;
            Object constantValue = LiteralNode.objectAsConstant(value);
            if (constantValue == LiteralNode.POSTSET_MARKER) {
                postsetValues.add(i);
                continue;
            }
            Property property = this.propertyMap.findProperty(key);
            if (property != null) {
                presetValues[property.getSlot()] = constantValue;
                continue;
            }
            long oldLength = arrayData.length();
            int index = ArrayIndex.getArrayIndex(key);
            assert (ArrayIndex.isValidArrayIndex(index));
            long longIndex = ArrayIndex.toLongIndex(index);
            if (longIndex >= oldLength) {
                arrayData = arrayData.ensure(longIndex);
            }
            arrayData = arrayData.set(index, constantValue, false);
            if (longIndex <= oldLength) continue;
            arrayData = arrayData.delete(oldLength, longIndex - 1L);
        }
        method._new(JO.class).dup();
        this.codegen.loadConstant(this.propertyMap);
        method.invoke(CompilerConstants.constructorNoLookup(JO.class, PropertyMap.class));
        method.dup();
        this.codegen.loadConstant(presetValues);
        method.putField(Type.getInternalName(ScriptObject.class), "spill", Type.OBJECT_ARRAY.getDescriptor());
        if (arrayData.length() > 0L) {
            method.dup();
            this.codegen.loadConstant(arrayData);
            method.invoke(CompilerConstants.virtualCallNoLookup(ScriptObject.class, "setArray", Void.TYPE, ArrayData.class));
        }
        Iterator iterator = postsetValues.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            String key = (String)this.keys.get(i);
            Property property = this.propertyMap.findProperty(key);
            if (property == null) {
                int index = ArrayIndex.getArrayIndex(key);
                assert (ArrayIndex.isValidArrayIndex(index));
                method.dup();
                method.load(ArrayIndex.toLongIndex(index));
                this.codegen.load(this.values.get(i));
                method.dynamicSetIndex(callSiteFlags);
                continue;
            }
            method.dup();
            method.getField(Type.getInternalName(ScriptObject.class), "spill", Type.OBJECT_ARRAY.getDescriptor());
            method.load(property.getSlot());
            this.codegen.load(this.values.get(i), Type.OBJECT);
            method.arraystore();
        }
    }

    @Override
    protected PropertyMap makeMap() {
        assert (this.propertyMap == null) : "property map already initialized";
        this.propertyMap = new MapCreator(JO.class, this.keys, this.symbols){

            @Override
            protected int getPropertyFlags(Symbol symbol, boolean hasArguments) {
                return super.getPropertyFlags(symbol, hasArguments) | 8 | 0x40;
            }
        }.makeSpillMap(false);
        return this.propertyMap;
    }
}

