/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

class SparseArrayData
extends ArrayData {
    static final long MAX_DENSE_LENGTH = 524288L;
    private ArrayData underlying;
    private final long maxDenseLength;
    private TreeMap<Long, Object> sparseMap;

    SparseArrayData(ArrayData underlying, long length) {
        this(underlying, length, new TreeMap<Long, Object>());
    }

    SparseArrayData(ArrayData underlying, long length, TreeMap<Long, Object> sparseMap) {
        super(length);
        assert (underlying.length() <= length);
        this.underlying = underlying;
        this.maxDenseLength = Math.max(524288L, underlying.length());
        this.sparseMap = sparseMap;
    }

    @Override
    public ArrayData copy() {
        return new SparseArrayData(this.underlying.copy(), this.length(), new TreeMap<Long, Object>((SortedMap<Long, Object>)this.sparseMap));
    }

    @Override
    public Object[] asObjectArray() {
        Map.Entry<Long, Object> entry;
        long key;
        int length = (int)Math.min(this.length(), Integer.MAX_VALUE);
        int underlyingLength = (int)Math.min((long)length, this.underlying.length());
        Object[] objArray = new Object[length];
        for (int i = 0; i < underlyingLength; ++i) {
            objArray[i] = this.underlying.getObject(i);
        }
        Arrays.fill(objArray, underlyingLength, length, ScriptRuntime.UNDEFINED);
        Iterator<Map.Entry<Long, Object>> iterator = this.sparseMap.entrySet().iterator();
        while (iterator.hasNext() && (key = (entry = iterator.next()).getKey().longValue()) <= Integer.MAX_VALUE) {
            objArray[(int)key] = entry.getValue();
        }
        return objArray;
    }

    @Override
    public void shiftLeft(int by) {
        this.underlying.shiftLeft(by);
        TreeMap<Long, Object> newSparseMap = new TreeMap<Long, Object>();
        for (Map.Entry<Long, Object> entry : this.sparseMap.entrySet()) {
            long newIndex = entry.getKey() - (long)by;
            if (newIndex < this.maxDenseLength) {
                this.underlying = this.underlying.set((int)newIndex, entry.getValue(), false);
                continue;
            }
            if (newIndex < 0L) continue;
            newSparseMap.put(newIndex, entry.getValue());
        }
        this.sparseMap = newSparseMap;
        this.setLength(Math.max(this.length() - (long)by, 0L));
    }

    @Override
    public ArrayData shiftRight(int by) {
        TreeMap<Long, Object> newSparseMap = new TreeMap<Long, Object>();
        if (this.underlying.length() + (long)by > this.maxDenseLength) {
            for (long i = this.maxDenseLength - (long)by; i < this.underlying.length(); ++i) {
                if (!this.underlying.has((int)i)) continue;
                newSparseMap.put(i + (long)by, this.underlying.getObject((int)i));
            }
            this.underlying = this.underlying.shrink((int)(this.maxDenseLength - (long)by));
        }
        this.underlying.shiftRight(by);
        for (Map.Entry<Long, Object> entry : this.sparseMap.entrySet()) {
            long newIndex = entry.getKey() + (long)by;
            newSparseMap.put(newIndex, entry.getValue());
        }
        this.sparseMap = newSparseMap;
        this.setLength(this.length() + (long)by);
        return this;
    }

    @Override
    public ArrayData ensure(long safeIndex) {
        if (safeIndex < this.maxDenseLength && this.underlying.length() <= safeIndex) {
            this.underlying = this.underlying.ensure(safeIndex);
        }
        this.setLength(Math.max(safeIndex + 1L, this.length()));
        return this;
    }

    @Override
    public ArrayData shrink(long newLength) {
        if (newLength < this.underlying.length()) {
            this.underlying = this.underlying.shrink(newLength);
            this.underlying.setLength(newLength);
            this.sparseMap.clear();
            this.setLength(newLength);
        }
        this.sparseMap.subMap(newLength, Long.MAX_VALUE).clear();
        this.setLength(newLength);
        return this;
    }

    @Override
    public ArrayData set(int index, Object value, boolean strict) {
        if (index >= 0 && (long)index < this.maxDenseLength) {
            this.ensure(index);
            this.underlying = this.underlying.set(index, value, strict);
            this.setLength(Math.max(this.underlying.length(), this.length()));
        } else {
            this.sparseMap.put(SparseArrayData.indexToKey(index), value);
            this.setLength(Math.max((long)(index + 1), this.length()));
        }
        return this;
    }

    @Override
    public ArrayData set(int index, int value, boolean strict) {
        if (index >= 0 && (long)index < this.maxDenseLength) {
            this.ensure(index);
            this.underlying = this.underlying.set(index, value, strict);
            this.setLength(Math.max(this.underlying.length(), this.length()));
        } else {
            this.sparseMap.put(SparseArrayData.indexToKey(index), value);
            this.setLength(Math.max((long)(index + 1), this.length()));
        }
        return this;
    }

    @Override
    public ArrayData set(int index, long value, boolean strict) {
        if (index >= 0 && (long)index < this.maxDenseLength) {
            this.ensure(index);
            this.underlying = this.underlying.set(index, value, strict);
            this.setLength(Math.max(this.underlying.length(), this.length()));
        } else {
            this.sparseMap.put(SparseArrayData.indexToKey(index), value);
            this.setLength(Math.max((long)(index + 1), this.length()));
        }
        return this;
    }

    @Override
    public ArrayData set(int index, double value, boolean strict) {
        if (index >= 0 && (long)index < this.maxDenseLength) {
            this.ensure(index);
            this.underlying = this.underlying.set(index, value, strict);
            this.setLength(Math.max(this.underlying.length(), this.length()));
        } else {
            this.sparseMap.put(SparseArrayData.indexToKey(index), value);
            this.setLength(Math.max((long)(index + 1), this.length()));
        }
        return this;
    }

    @Override
    public ArrayData setEmpty(int index) {
        this.underlying.setEmpty(index);
        return this;
    }

    @Override
    public ArrayData setEmpty(long lo, long hi) {
        this.underlying.setEmpty(lo, hi);
        return this;
    }

    @Override
    public int getInt(int index) {
        if (index >= 0 && (long)index < this.maxDenseLength) {
            return this.underlying.getInt(index);
        }
        return JSType.toInt32(this.sparseMap.get(SparseArrayData.indexToKey(index)));
    }

    @Override
    public long getLong(int index) {
        if (index >= 0 && (long)index < this.maxDenseLength) {
            return this.underlying.getLong(index);
        }
        return JSType.toLong(this.sparseMap.get(SparseArrayData.indexToKey(index)));
    }

    @Override
    public double getDouble(int index) {
        if (index >= 0 && (long)index < this.maxDenseLength) {
            return this.underlying.getDouble(index);
        }
        return JSType.toNumber(this.sparseMap.get(SparseArrayData.indexToKey(index)));
    }

    @Override
    public Object getObject(int index) {
        if (index >= 0 && (long)index < this.maxDenseLength) {
            return this.underlying.getObject(index);
        }
        Long key = SparseArrayData.indexToKey(index);
        if (this.sparseMap.containsKey(key)) {
            return this.sparseMap.get(key);
        }
        return ScriptRuntime.UNDEFINED;
    }

    @Override
    public boolean has(int index) {
        if (index >= 0 && (long)index < this.maxDenseLength) {
            return (long)index < this.underlying.length() && this.underlying.has(index);
        }
        return this.sparseMap.containsKey(SparseArrayData.indexToKey(index));
    }

    @Override
    public ArrayData delete(int index) {
        if (index >= 0 && (long)index < this.maxDenseLength) {
            if ((long)index < this.underlying.length()) {
                this.underlying = this.underlying.delete(index);
            }
        } else {
            this.sparseMap.remove(SparseArrayData.indexToKey(index));
        }
        return this;
    }

    @Override
    public ArrayData delete(long fromIndex, long toIndex) {
        if (fromIndex < this.maxDenseLength && fromIndex < this.underlying.length()) {
            this.underlying = this.underlying.delete(fromIndex, Math.min(toIndex, this.underlying.length() - 1L));
        }
        if (toIndex >= this.maxDenseLength) {
            this.sparseMap.subMap(fromIndex, true, toIndex, true).clear();
        }
        return this;
    }

    private static Long indexToKey(int index) {
        return (long)index & 0xFFFFFFFFL;
    }

    @Override
    protected ArrayData convert(Class<?> type) {
        this.underlying = this.underlying.convert(type);
        return this;
    }

    @Override
    public Object pop() {
        if (this.length() == 0L) {
            return ScriptRuntime.UNDEFINED;
        }
        if (this.length() == this.underlying.length()) {
            Object result = this.underlying.pop();
            this.setLength(this.underlying.length());
            return result;
        }
        this.setLength(this.length() - 1L);
        Long key = this.length();
        return this.sparseMap.containsKey(key) ? this.sparseMap.remove(key) : ScriptRuntime.UNDEFINED;
    }

    @Override
    public ArrayData slice(long from, long to) {
        assert (to <= this.length());
        long start = from < 0L ? from + this.length() : from;
        long newLength = to - start;
        if (start >= 0L && to <= this.maxDenseLength) {
            if (newLength <= this.underlying.length()) {
                return this.underlying.slice(from, to);
            }
            return this.underlying.slice(from, to).ensure(newLength - 1L).delete(this.underlying.length(), newLength);
        }
        ArrayData sliced = EMPTY_ARRAY;
        sliced = sliced.ensure(newLength - 1L);
        long i = start;
        while (i < to) {
            if (this.has((int)i)) {
                sliced = sliced.set((int)(i - start), this.getObject((int)i), false);
            }
            i = this.nextIndex(i);
        }
        assert (sliced.length() == newLength);
        return sliced;
    }

    @Override
    public long nextIndex(long index) {
        if (index < this.underlying.length() - 1L) {
            return this.underlying.nextIndex(index);
        }
        Long nextKey = this.sparseMap.higherKey(index);
        if (nextKey != null) {
            return nextKey;
        }
        return this.length();
    }
}

