/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class PulseLogger {
    public static final boolean PULSE_LOGGING_ENABLED = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("javafx.pulseLogger");
        }
    });
    public static final PulseLogger PULSE_LOGGER = PULSE_LOGGING_ENABLED ? new PulseLogger() : null;
    private static long THRESHOLD = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.getInteger("javafx.pulseLogger.threshold", 17);
        }
    }).intValue();
    private int pulseCount = 1;
    private static final int INTER_PULSE_DATA = -1;
    private volatile int wrapCount = 0;
    private volatile PulseData fxData;
    private volatile PulseData renderData;
    private long lastPulseStartTime;
    private boolean nullRenderFlag = false;
    private PulseData head;
    private PulseData tail;
    AtomicInteger active = new AtomicInteger(0);
    private static final int AVAILABLE = 0;
    private static final int INCOMPLETE = 1;
    private static final int COMPLETE = 2;

    private PulseLogger() {
        this.head = new PulseData();
        this.head.next = this.tail = new PulseData();
    }

    private PulseData allocate(int n) {
        PulseData pulseData;
        if (this.head != this.tail && this.head.state == 0) {
            pulseData = this.head;
            this.head = this.head.next;
            pulseData.next = null;
        } else {
            pulseData = new PulseData();
        }
        this.tail.next = pulseData;
        this.tail = pulseData;
        pulseData.init(n);
        return pulseData;
    }

    public void pulseStart() {
        if (this.fxData != null) {
            this.fxData.state = 2;
            if (this.active.incrementAndGet() == 1) {
                this.fxData.printAndReset();
                this.active.decrementAndGet();
            }
        }
        this.fxData = this.allocate(this.pulseCount++);
        if (this.lastPulseStartTime > 0L) {
            this.fxData.interval = this.fxData.startTime - this.lastPulseStartTime;
        }
        this.lastPulseStartTime = this.fxData.startTime;
    }

    public void renderStart() {
        this.fxData.pushedRender = true;
        this.renderData = this.fxData;
        this.active.incrementAndGet();
    }

    public void pulseEnd() {
        if (!this.fxData.pushedRender) {
            this.fxData.state = 2;
            if (this.active.incrementAndGet() == 1) {
                this.fxData.printAndReset();
                this.active.decrementAndGet();
            }
        }
        this.fxData = null;
    }

    public void renderEnd() {
        this.renderData.state = 2;
        while (true) {
            this.renderData.printAndReset();
            if (this.active.decrementAndGet() == 0) break;
            this.renderData = this.renderData.next;
        }
        this.renderData = null;
    }

    public void fxMessage(String string) {
        if (this.fxData == null) {
            this.fxData = this.allocate(-1);
        }
        this.fxData.message.append("T").append(Thread.currentThread().getId()).append(" : ").append(string).append("\n");
    }

    public void fxMessage(long l, long l2, String string) {
        if (this.fxData == null) {
            this.fxData = this.allocate(-1);
        }
        this.fxData.message.append("T").append(Thread.currentThread().getId()).append(" (").append(l - this.fxData.startTime).append(" +").append(l2 - l).append("ms): ").append(string).append("\n");
    }

    public void fxIncrementCounter(String string) {
        Map<String, Integer> map;
        if (this.fxData == null) {
            this.fxData = this.allocate(-1);
        }
        if ((map = this.fxData.counters).containsKey(string)) {
            map.put(string, map.get(string) + 1);
        } else {
            map.put(string, 1);
        }
    }

    public void renderMessage(String string) {
        if (this.renderData == null) {
            this.nullRenderFlag = true;
            return;
        }
        this.renderData.message.append("T").append(Thread.currentThread().getId()).append(" : ").append(string).append("\n");
    }

    public void renderMessage(long l, long l2, String string) {
        if (this.renderData == null) {
            this.nullRenderFlag = true;
            return;
        }
        this.renderData.message.append("T").append(Thread.currentThread().getId()).append(" (").append(l - this.renderData.startTime).append(" +").append(l2 - l).append("ms): ").append(string).append("\n");
    }

    public void renderIncrementCounter(String string) {
        if (this.renderData == null) {
            this.nullRenderFlag = true;
            return;
        }
        Map<String, Integer> map = this.renderData.counters;
        if (map.containsKey(string)) {
            map.put(string, map.get(string) + 1);
        } else {
            map.put(string, 1);
        }
    }

    private final class PulseData {
        PulseData next;
        volatile int state = 0;
        long startTime;
        long interval;
        int pulseCount;
        boolean pushedRender;
        StringBuffer message = new StringBuffer();
        Map<String, Integer> counters = new ConcurrentHashMap<String, Integer>();

        private PulseData() {
        }

        void init(int n) {
            this.state = 1;
            this.pulseCount = n;
            this.startTime = System.currentTimeMillis();
            this.interval = 0L;
            this.pushedRender = false;
        }

        void printAndReset() {
            long l = System.currentTimeMillis();
            long l2 = l - this.startTime;
            if (PulseLogger.this.nullRenderFlag) {
                System.err.println("\nWARNING: unexpected render thread activity");
                PulseLogger.this.nullRenderFlag = false;
            }
            if (this.state != 2) {
                System.err.println("\nWARNING: logging incomplete state");
            }
            if (l2 <= THRESHOLD) {
                if (this.pulseCount != -1) {
                    System.err.print((PulseLogger.this.wrapCount++ % 10 == 0 ? "\n[" : "[") + this.pulseCount + " " + this.interval + "ms:" + l2 + "ms]");
                }
            } else {
                if (this.pulseCount == -1) {
                    System.err.println("\n\nINTER PULSE LOG DATA");
                } else {
                    System.err.print("\n\nPULSE: " + this.pulseCount + " [" + this.interval + "ms:" + l2 + "ms]");
                    if (!this.pushedRender) {
                        System.err.print(" Required No Rendering");
                    }
                    System.err.println();
                }
                System.err.print(this.message);
                if (!this.counters.isEmpty()) {
                    System.err.println("Counters:");
                    ArrayList<Map.Entry<String, Integer>> arrayList = new ArrayList<Map.Entry<String, Integer>>(this.counters.entrySet());
                    Collections.sort(arrayList, new Comparator<Map.Entry<String, Integer>>(){

                        @Override
                        public int compare(Map.Entry<String, Integer> entry, Map.Entry<String, Integer> entry2) {
                            return entry.getKey().compareTo(entry2.getKey());
                        }
                    });
                    for (Map.Entry entry : arrayList) {
                        System.err.println("\t" + (String)entry.getKey() + ": " + entry.getValue());
                    }
                }
                PulseLogger.this.wrapCount = 0;
            }
            this.message.setLength(0);
            this.counters.clear();
            this.state = 0;
        }
    }
}

