/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.AccordionBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.TitledPaneSkin;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Skin;
import javafx.scene.control.TitledPane;
import javafx.scene.shape.Rectangle;

public class AccordionSkin
extends BehaviorSkinBase<Accordion, AccordionBehavior> {
    private TitledPane firstTitledPane;
    private Rectangle clipRect;
    private boolean forceRelayout = false;
    private boolean relayout = false;
    private double previousHeight = 0.0;
    private TitledPane expandedPane = null;
    private TitledPane previousPane = null;
    private Map<TitledPane, ChangeListener<Boolean>> listeners = new HashMap<TitledPane, ChangeListener<Boolean>>();

    public AccordionSkin(final Accordion accordion) {
        super(accordion, new AccordionBehavior(accordion));
        accordion.getPanes().addListener(new ListChangeListener<TitledPane>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends TitledPane> change) {
                if (AccordionSkin.this.firstTitledPane != null) {
                    AccordionSkin.this.firstTitledPane.getStyleClass().remove("first-titled-pane");
                }
                if (!accordion.getPanes().isEmpty()) {
                    AccordionSkin.this.firstTitledPane = (TitledPane)accordion.getPanes().get(0);
                    AccordionSkin.this.firstTitledPane.getStyleClass().add("first-titled-pane");
                }
                AccordionSkin.this.getChildren().setAll((Collection<Node>)accordion.getPanes());
                while (change.next()) {
                    AccordionSkin.this.removeTitledPaneListeners(change.getRemoved());
                    AccordionSkin.this.initTitledPaneListeners(change.getAddedSubList());
                }
                AccordionSkin.this.forceRelayout = true;
            }
        });
        if (!accordion.getPanes().isEmpty()) {
            this.firstTitledPane = (TitledPane)accordion.getPanes().get(0);
            this.firstTitledPane.getStyleClass().add("first-titled-pane");
        }
        this.clipRect = new Rectangle();
        ((Accordion)this.getSkinnable()).setClip(this.clipRect);
        this.initTitledPaneListeners(accordion.getPanes());
        this.getChildren().setAll((Collection<Node>)accordion.getPanes());
        ((Accordion)this.getSkinnable()).requestLayout();
        this.registerChangeListener(((Accordion)this.getSkinnable()).widthProperty(), "WIDTH");
        this.registerChangeListener(((Accordion)this.getSkinnable()).heightProperty(), "HEIGHT");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("WIDTH".equals(string)) {
            this.clipRect.setWidth(((Accordion)this.getSkinnable()).getWidth());
        } else if ("HEIGHT".equals(string)) {
            this.clipRect.setHeight(((Accordion)this.getSkinnable()).getHeight());
            this.relayout = true;
        }
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        double d6 = 0.0;
        for (Node node : this.getChildren()) {
            d6 += this.snapSize(node.minHeight(d));
        }
        return d6;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        double d6 = 0.0;
        if (this.expandedPane != null) {
            d6 += this.expandedPane.prefHeight(-1.0);
        }
        if (this.previousPane != null && !this.previousPane.equals(this.expandedPane)) {
            d6 += this.previousPane.prefHeight(-1.0);
        }
        for (Node node : this.getChildren()) {
            TitledPane titledPane = (TitledPane)node;
            if (titledPane.equals(this.expandedPane) || titledPane.equals(this.previousPane)) continue;
            d6 += this.snapSize(titledPane.minHeight(d));
        }
        return d6 + d2 + d4;
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        boolean bl = this.forceRelayout || this.relayout && this.previousHeight != d4;
        this.forceRelayout = false;
        this.previousHeight = d4;
        double d5 = 0.0;
        for (TitledPane titledPane : ((Accordion)this.getSkinnable()).getPanes()) {
            if (titledPane.equals(this.expandedPane)) continue;
            d5 += this.snapSize(titledPane.minHeight(-1.0));
        }
        double d6 = d4 - d5;
        for (TitledPane titledPane : ((Accordion)this.getSkinnable()).getPanes()) {
            double d7;
            Skin<?> skin = titledPane.getSkin();
            if (skin instanceof TitledPaneSkin) {
                ((TitledPaneSkin)skin).setMaxTitledPaneHeightForAccordion(d6);
                d7 = this.snapSize(((TitledPaneSkin)skin).getTitledPaneHeightForAccordion());
            } else {
                d7 = titledPane.prefHeight(d3);
            }
            titledPane.resize(d3, d7);
            boolean bl2 = true;
            if (!bl && this.previousPane != null && this.expandedPane != null) {
                ObservableList<TitledPane> observableList = ((Accordion)this.getSkinnable()).getPanes();
                int n = observableList.indexOf(this.previousPane);
                int n2 = observableList.indexOf(this.expandedPane);
                int n3 = observableList.indexOf(titledPane);
                if (n < n2) {
                    if (n3 <= n2) {
                        titledPane.relocate(d, d2);
                        d2 += d7;
                        bl2 = false;
                    }
                } else if (n > n2) {
                    if (n3 <= n) {
                        titledPane.relocate(d, d2);
                        d2 += d7;
                        bl2 = false;
                    }
                } else {
                    titledPane.relocate(d, d2);
                    d2 += d7;
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            titledPane.relocate(d, d2);
            d2 += d7;
        }
    }

    private void initTitledPaneListeners(List<? extends TitledPane> list) {
        for (TitledPane titledPane : list) {
            titledPane.setExpanded(titledPane == ((Accordion)this.getSkinnable()).getExpandedPane());
            if (titledPane.isExpanded()) {
                this.expandedPane = titledPane;
            }
            ChangeListener<Boolean> changeListener = this.expandedPropertyListener(titledPane);
            titledPane.expandedProperty().addListener(changeListener);
            this.listeners.put(titledPane, changeListener);
        }
    }

    private void removeTitledPaneListeners(List<? extends TitledPane> list) {
        for (TitledPane titledPane : list) {
            if (!this.listeners.containsKey(titledPane)) continue;
            titledPane.expandedProperty().removeListener(this.listeners.get(titledPane));
            this.listeners.remove(titledPane);
        }
    }

    private ChangeListener<Boolean> expandedPropertyListener(final TitledPane titledPane) {
        return new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                AccordionSkin.this.previousPane = AccordionSkin.this.expandedPane;
                Accordion accordion = (Accordion)AccordionSkin.this.getSkinnable();
                if (bl2.booleanValue()) {
                    if (AccordionSkin.this.expandedPane != null) {
                        AccordionSkin.this.expandedPane.setExpanded(false);
                    }
                    if (titledPane != null) {
                        accordion.setExpandedPane(titledPane);
                    }
                    AccordionSkin.this.expandedPane = accordion.getExpandedPane();
                } else {
                    AccordionSkin.this.expandedPane = null;
                    accordion.setExpandedPane(null);
                }
            }
        };
    }
}

