/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TableViewBehavior;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class TableViewSkin<T>
extends TableViewSkinBase<T, T, TableView<T>, TableViewBehavior<T>, TableRow<T>, TableColumn<T, ?>> {
    private final TableView<T> tableView;

    public TableViewSkin(final TableView<T> tableView) {
        super(tableView, new TableViewBehavior<T>(tableView));
        this.tableView = tableView;
        this.flow.setFixedCellSize(tableView.getFixedCellSize());
        super.init(tableView);
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (tableView.getEditingCell() != null) {
                    tableView.edit(-1, null);
                }
                tableView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        TableViewBehavior tableViewBehavior = (TableViewBehavior)this.getBehavior();
        tableViewBehavior.setOnFocusPreviousRow(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onFocusPreviousCell();
            }
        });
        tableViewBehavior.setOnFocusNextRow(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onFocusNextCell();
            }
        });
        tableViewBehavior.setOnMoveToFirstCell(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onMoveToFirstCell();
            }
        });
        tableViewBehavior.setOnMoveToLastCell(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onMoveToLastCell();
            }
        });
        tableViewBehavior.setOnScrollPageDown(new Callback<Boolean, Integer>(){

            @Override
            public Integer call(Boolean bl) {
                return TableViewSkin.this.onScrollPageDown(bl);
            }
        });
        tableViewBehavior.setOnScrollPageUp(new Callback<Boolean, Integer>(){

            @Override
            public Integer call(Boolean bl) {
                return TableViewSkin.this.onScrollPageUp(bl);
            }
        });
        tableViewBehavior.setOnSelectPreviousRow(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onSelectPreviousCell();
            }
        });
        tableViewBehavior.setOnSelectNextRow(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onSelectNextCell();
            }
        });
        tableViewBehavior.setOnSelectLeftCell(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onSelectLeftCell();
            }
        });
        tableViewBehavior.setOnSelectRightCell(new Runnable(){

            @Override
            public void run() {
                TableViewSkin.this.onSelectRightCell();
            }
        });
        this.registerChangeListener(tableView.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("FIXED_CELL_SIZE".equals(string)) {
            this.flow.setFixedCellSize(((TableView)this.getSkinnable()).getFixedCellSize());
        }
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getVisibleLeafColumns() {
        return this.tableView.getVisibleLeafColumns();
    }

    @Override
    protected int getVisibleLeafIndex(TableColumn<T, ?> tableColumn) {
        return this.tableView.getVisibleLeafIndex(tableColumn);
    }

    @Override
    protected TableColumn<T, ?> getVisibleLeafColumn(int n) {
        return this.tableView.getVisibleLeafColumn(n);
    }

    protected TableView.TableViewFocusModel<T> getFocusModel() {
        return this.tableView.getFocusModel();
    }

    protected TablePosition<T, ?> getFocusedCell() {
        return this.tableView.getFocusModel().getFocusedCell();
    }

    @Override
    protected TableSelectionModel<T> getSelectionModel() {
        return this.tableView.getSelectionModel();
    }

    @Override
    protected ObjectProperty<Callback<TableView<T>, TableRow<T>>> rowFactoryProperty() {
        return this.tableView.rowFactoryProperty();
    }

    @Override
    protected ObjectProperty<Node> placeholderProperty() {
        return this.tableView.placeholderProperty();
    }

    @Override
    protected ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.tableView.itemsProperty();
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getColumns() {
        return this.tableView.getColumns();
    }

    @Override
    protected BooleanProperty tableMenuButtonVisibleProperty() {
        return this.tableView.tableMenuButtonVisibleProperty();
    }

    @Override
    protected ObjectProperty<Callback<ResizeFeaturesBase, Boolean>> columnResizePolicyProperty() {
        return this.tableView.columnResizePolicyProperty();
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getSortOrder() {
        return this.tableView.getSortOrder();
    }

    @Override
    protected boolean resizeColumn(TableColumn<T, ?> tableColumn, double d) {
        return this.tableView.resizeColumn(tableColumn, d);
    }

    @Override
    protected void resizeColumnToFitContent(TableColumn<T, ?> tableColumn, int n) {
        Node node;
        TableColumn<T, ?> tableColumn2 = tableColumn;
        List list = (List)this.itemsProperty().get();
        if (list == null || list.isEmpty()) {
            return;
        }
        Callback<TableColumn<T, ?>, TableCell<T, ?>> callback = tableColumn2.getCellFactory();
        if (callback == null) {
            return;
        }
        TableCell<T, ?> tableCell = callback.call(tableColumn2);
        if (tableCell == null) {
            return;
        }
        tableCell.getProperties().put("deferToParentPrefWidth", Boolean.TRUE);
        double d = 10.0;
        Node node2 = node = tableCell.getSkin() == null ? null : tableCell.getSkin().getNode();
        if (node instanceof Region) {
            Region region = (Region)node;
            d = region.snappedLeftInset() + region.snappedRightInset();
        }
        int n2 = n == -1 ? list.size() : Math.min(list.size(), n);
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            tableCell.updateTableColumn(tableColumn2);
            tableCell.updateTableView(this.tableView);
            tableCell.updateIndex(i);
            if ((tableCell.getText() == null || tableCell.getText().isEmpty()) && tableCell.getGraphic() == null) continue;
            this.getChildren().add(tableCell);
            tableCell.impl_processCSS(false);
            d2 = Math.max(d2, tableCell.prefWidth(-1.0));
            this.getChildren().remove(tableCell);
        }
        tableCell.updateIndex(-1);
        double d3 = d2 + d;
        if (this.tableView.getColumnResizePolicy() == TableView.CONSTRAINED_RESIZE_POLICY) {
            d3 = Math.max(d3, tableColumn2.getWidth());
        }
        tableColumn2.impl_setWidth(d3);
    }

    @Override
    public int getItemCount() {
        return this.tableView.getItems() == null ? 0 : this.tableView.getItems().size();
    }

    @Override
    public TableRow<T> createCell() {
        TableRow<T> tableRow = this.tableView.getRowFactory() != null ? this.tableView.getRowFactory().call(this.tableView) : new TableRow<T>();
        tableRow.updateTableView(this.tableView);
        return tableRow;
    }

    @Override
    protected void horizontalScroll() {
        super.horizontalScroll();
        if (((TableView)this.getSkinnable()).getFixedCellSize() > 0.0) {
            this.flow.requestCellLayout();
        }
    }
}

