/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.Logging;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import sun.util.logging.PlatformLogger;

public class ContainerTabOrder
implements Algorithm {
    PlatformLogger focusLogger = Logging.getFocusLogger();

    ContainerTabOrder() {
    }

    @Override
    public Node traverse(Node node, Direction direction, TraversalEngine traversalEngine) {
        Node node2 = null;
        int n = -1;
        if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
            this.focusLogger.finer("old focus owner : " + node + ", bounds : " + traversalEngine.getBounds(node));
        }
        if (Direction.NEXT.equals((Object)direction)) {
            node2 = this.findNextFocusablePeer(node);
        } else if (Direction.PREVIOUS.equals((Object)direction)) {
            node2 = this.findPreviousFocusablePeer(node);
        } else if (Direction.UP.equals((Object)direction) || Direction.DOWN.equals((Object)direction) || Direction.LEFT.equals((Object)direction) || Direction.RIGHT.equals((Object)direction)) {
            List<Node> list = traversalEngine.getAllTargetNodes();
            List<Bounds> list2 = traversalEngine.getTargetBounds(list);
            int n2 = this.trav2D(traversalEngine.getBounds(node), direction, list2);
            if (n2 != -1) {
                node2 = list.get(n2);
            }
            list.clear();
            list2.clear();
        }
        if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
            if (node2 != null) {
                this.focusLogger.finer("new focus owner : " + node2 + ", bounds : " + traversalEngine.getBounds(node2));
            } else {
                this.focusLogger.finer("no focus transfer");
            }
        }
        return node2;
    }

    private Node findNextFocusablePeer(Node node) {
        Object object;
        Node node2 = node;
        Node node3 = null;
        List<Node> list = this.findPeers(node2);
        if (list == null) {
            if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
                this.focusLogger.finer("can't find peers for a node without a parent");
            }
            return null;
        }
        int n = list.indexOf(node2);
        if (n == -1) {
            if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
                this.focusLogger.finer("index not founds, no focus transfer");
            }
            return null;
        }
        node3 = this.findNextFocusableInList(list, n + 1);
        while (node3 == null && node2 != null) {
            Parent parent = node2.getParent();
            if (parent != null && (object = this.findPeers(parent)) != null) {
                int n2 = object.indexOf(parent);
                node3 = this.findNextFocusableInList((List<Node>)object, n2 + 1);
            }
            node2 = parent;
        }
        if (node3 == null) {
            object = null;
            for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                object = parent;
            }
            list = ((Parent)object).getChildrenUnmodifiable();
            node3 = this.findNextFocusableInList(list, 0);
        }
        return node3;
    }

    private Node findNextParent(Node node) {
        return null;
    }

    private Node findNextFocusableInList(List<Node> list, int n) {
        Node node = null;
        for (int i = n; i < list.size(); ++i) {
            ObservableList<Node> observableList;
            Node node2 = list.get(i);
            if (node2.isFocusTraversable() && !node2.isDisabled() && node2.impl_isTreeVisible()) {
                node = node2;
                break;
            }
            if (node2 instanceof Parent && (observableList = ((Parent)node2).getChildrenUnmodifiable()).size() > 0 && (node = this.findNextFocusableInList(observableList, 0)) != null) break;
        }
        return node;
    }

    private Node findPreviousFocusablePeer(Node node) {
        Object object;
        Node node2 = node;
        Node node3 = null;
        List<Node> list = this.findPeers(node2);
        int n = list.indexOf(node2);
        if (n == -1) {
            if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
                this.focusLogger.finer("index not founds, no focus transfer");
            }
            return null;
        }
        node3 = this.findPreviousFocusableInList(list, n - 1);
        while (node3 == null && node2 != null) {
            Parent parent = node2.getParent();
            if (parent != null && (object = this.findPeers(parent)) != null) {
                int n2 = object.indexOf(parent);
                node3 = this.findPreviousFocusableInList((List<Node>)object, n2 - 1);
            }
            node2 = parent;
        }
        if (node3 == null) {
            object = null;
            for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                object = parent;
            }
            list = ((Parent)object).getChildrenUnmodifiable();
            node3 = this.findPreviousFocusableInList(list, list.size() - 1);
        }
        return node3;
    }

    private Node findPreviousFocusableInList(List<Node> list, int n) {
        Node node = null;
        for (int i = n; i >= 0; --i) {
            ObservableList<Node> observableList;
            Node node2 = list.get(i);
            if (node2.isFocusTraversable() && !node2.isDisabled() && node2.impl_isTreeVisible()) {
                node = node2;
                break;
            }
            if (node2 instanceof Parent && (observableList = ((Parent)node2).getChildrenUnmodifiable()).size() > 0 && (node = this.findPreviousFocusableInList(observableList, observableList.size() - 1)) != null) break;
        }
        return node;
    }

    private List<Node> findPeers(Node node) {
        ObservableList<Node> observableList = null;
        Parent parent = node.getParent();
        if (parent != null) {
            observableList = parent.getChildrenUnmodifiable();
        }
        return observableList;
    }

    private static Parent getParent(Node node) {
        return node.getParent() instanceof Group ? node.getParent().getParent() : node.getParent();
    }

    private int trav2D(Bounds bounds, Direction direction, List<Bounds> list) {
        Bounds bounds2 = null;
        double d = 0.0;
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            Bounds bounds3 = list.get(i);
            double d3 = this.outDistance(direction, bounds, bounds3);
            if (this.isOnAxis(direction, bounds, bounds3)) {
                d2 = d3 + this.centerSideDistance(direction, bounds, bounds3) / 100.0;
            } else {
                double d4 = this.cornerSideDistance(direction, bounds, bounds3);
                d2 = 100000.0 + d3 * d3 + 9.0 * d4 * d4;
            }
            if (d3 < 0.0 || bounds2 != null && !(d2 < d)) continue;
            bounds2 = bounds3;
            d = d2;
            n = i;
        }
        return n;
    }

    private boolean isOnAxis(Direction direction, Bounds bounds, Bounds bounds2) {
        double d;
        double d2;
        double d3;
        double d4;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d4 = bounds.getMinX();
            d3 = bounds.getMaxX();
            d2 = bounds2.getMinX();
            d = bounds2.getMaxX();
        } else {
            d4 = bounds.getMinY();
            d3 = bounds.getMaxY();
            d2 = bounds2.getMinY();
            d = bounds2.getMaxY();
        }
        return d2 <= d3 && d >= d4;
    }

    private double outDistance(Direction direction, Bounds bounds, Bounds bounds2) {
        double d = direction == Direction.UP ? bounds.getMinY() - bounds2.getMaxY() : (direction == Direction.DOWN ? bounds2.getMinY() - bounds.getMaxY() : (direction == Direction.LEFT ? bounds.getMinX() - bounds2.getMaxX() : bounds2.getMinX() - bounds.getMaxX()));
        return d;
    }

    private double centerSideDistance(Direction direction, Bounds bounds, Bounds bounds2) {
        double d;
        double d2;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d2 = bounds.getMinX() + bounds.getWidth() / 2.0;
            d = bounds2.getMinX() + bounds2.getWidth() / 2.0;
        } else {
            d2 = bounds.getMinY() + bounds.getHeight() / 2.0;
            d = bounds2.getMinY() + bounds2.getHeight() / 2.0;
        }
        return Math.abs(d - d2);
    }

    private double cornerSideDistance(Direction direction, Bounds bounds, Bounds bounds2) {
        double d = direction == Direction.UP || direction == Direction.DOWN ? (bounds2.getMinX() > bounds.getMaxX() ? bounds2.getMinX() - bounds.getMaxX() : bounds.getMinX() - bounds2.getMaxX()) : (bounds2.getMinY() > bounds.getMaxY() ? bounds2.getMinY() - bounds.getMaxY() : bounds.getMinY() - bounds2.getMaxY());
        return d;
    }
}

