/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import com.sun.javafx.scene.control.skin.DatePickerSkin;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DecimalStyle;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.DateCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class DatePicker
extends ComboBoxBase<LocalDate> {
    private LocalDate lastValidDate = null;
    private Chronology lastValidChronology = IsoChronology.INSTANCE;
    private ObjectProperty<Callback<DatePicker, DateCell>> dayCellFactory;
    private ObjectProperty<Chronology> chronology = new SimpleObjectProperty<Object>(this, "chronology", null);
    private BooleanProperty showWeekNumbers;
    private ObjectProperty<StringConverter<LocalDate>> converter = new SimpleObjectProperty<Object>(this, "converter", null);
    private StringConverter<LocalDate> defaultConverter = new StringConverter<LocalDate>(){

        @Override
        public String toString(LocalDate localDate) {
            if (localDate != null) {
                ChronoLocalDate chronoLocalDate;
                Locale locale = Locale.getDefault(Locale.Category.FORMAT);
                Chronology chronology = DatePicker.this.getChronology();
                try {
                    chronoLocalDate = chronology.date(localDate);
                }
                catch (DateTimeException dateTimeException) {
                    System.err.println(dateTimeException);
                    chronology = IsoChronology.INSTANCE;
                    chronoLocalDate = localDate;
                }
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale).withChronology(chronology).withDecimalStyle(DecimalStyle.of(locale));
                String string = DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.SHORT, null, chronology, locale);
                if (string.contains("yy") && !string.contains("yyy")) {
                    String string2 = string.replace("yy", "yyyy");
                    dateTimeFormatter = DateTimeFormatter.ofPattern(string2).withDecimalStyle(DecimalStyle.of(locale));
                }
                return dateTimeFormatter.format(chronoLocalDate);
            }
            return "";
        }

        @Override
        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                Locale locale = Locale.getDefault(Locale.Category.FORMAT);
                Chronology chronology = DatePicker.this.getChronology();
                String string2 = DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.SHORT, null, chronology, locale);
                DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().parseLenient().appendPattern(string2).toFormatter().withChronology(chronology).withDecimalStyle(DecimalStyle.of(locale));
                TemporalAccessor temporalAccessor = dateTimeFormatter.parse(string);
                ChronoLocalDate chronoLocalDate = chronology.date(temporalAccessor);
                return LocalDate.from(chronoLocalDate);
            }
            return null;
        }
    };
    private ReadOnlyObjectWrapper<TextField> editor;
    private static final String DEFAULT_STYLE_CLASS = "date-picker";

    public DatePicker() {
        this(null);
        this.valueProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                LocalDate localDate = (LocalDate)DatePicker.this.getValue();
                Chronology chronology = DatePicker.this.getChronology();
                if (DatePicker.this.validateDate(chronology, localDate)) {
                    DatePicker.this.lastValidDate = localDate;
                } else {
                    System.err.println("Restoring value to " + (DatePicker.this.lastValidDate == null ? "null" : DatePicker.this.getConverter().toString(DatePicker.this.lastValidDate)));
                    DatePicker.this.setValue(DatePicker.this.lastValidDate);
                }
            }
        });
        this.chronologyProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                LocalDate localDate = (LocalDate)DatePicker.this.getValue();
                Chronology chronology = DatePicker.this.getChronology();
                if (DatePicker.this.validateDate(chronology, localDate)) {
                    DatePicker.this.lastValidChronology = chronology;
                } else {
                    System.err.println("Restoring value to " + DatePicker.this.lastValidChronology);
                    DatePicker.this.setChronology(DatePicker.this.lastValidChronology);
                }
            }
        });
    }

    private boolean validateDate(Chronology chronology, LocalDate localDate) {
        try {
            if (localDate != null) {
                chronology.date(localDate);
            }
            return true;
        }
        catch (DateTimeException dateTimeException) {
            System.err.println(dateTimeException);
            return false;
        }
    }

    public DatePicker(LocalDate localDate) {
        this.setValue(localDate);
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setEditable(true);
    }

    public final void setDayCellFactory(Callback<DatePicker, DateCell> callback) {
        this.dayCellFactoryProperty().set(callback);
    }

    public final Callback<DatePicker, DateCell> getDayCellFactory() {
        return this.dayCellFactory != null ? (Callback)this.dayCellFactory.get() : null;
    }

    public final ObjectProperty<Callback<DatePicker, DateCell>> dayCellFactoryProperty() {
        if (this.dayCellFactory == null) {
            this.dayCellFactory = new SimpleObjectProperty<Callback<DatePicker, DateCell>>(this, "dayCellFactory");
        }
        return this.dayCellFactory;
    }

    public final ObjectProperty<Chronology> chronologyProperty() {
        return this.chronology;
    }

    public final Chronology getChronology() {
        Chronology chronology = (Chronology)this.chronology.get();
        if (chronology == null) {
            try {
                chronology = Chronology.ofLocale(Locale.getDefault(Locale.Category.FORMAT));
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            if (chronology == null) {
                chronology = IsoChronology.INSTANCE;
            }
        }
        return chronology;
    }

    public final void setChronology(Chronology chronology) {
        this.chronology.setValue(chronology);
    }

    public final BooleanProperty showWeekNumbersProperty() {
        if (this.showWeekNumbers == null) {
            String string = Locale.getDefault(Locale.Category.FORMAT).getCountry();
            boolean bl = !string.isEmpty() && ControlResources.getNonTranslatableString("DatePicker.showWeekNumbers").contains(string);
            this.showWeekNumbers = new StyleableBooleanProperty(bl){

                @Override
                public CssMetaData<DatePicker, Boolean> getCssMetaData() {
                    return StyleableProperties.SHOW_WEEK_NUMBERS;
                }

                @Override
                public Object getBean() {
                    return DatePicker.this;
                }

                @Override
                public String getName() {
                    return "showWeekNumbers";
                }
            };
        }
        return this.showWeekNumbers;
    }

    public final void setShowWeekNumbers(boolean bl) {
        this.showWeekNumbersProperty().setValue(bl);
    }

    public final boolean isShowWeekNumbers() {
        return this.showWeekNumbersProperty().getValue();
    }

    public final ObjectProperty<StringConverter<LocalDate>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<LocalDate> stringConverter) {
        this.converterProperty().set(stringConverter);
    }

    public final StringConverter<LocalDate> getConverter() {
        StringConverter stringConverter = (StringConverter)this.converterProperty().get();
        if (stringConverter != null) {
            return stringConverter;
        }
        return this.defaultConverter;
    }

    public final TextField getEditor() {
        return (TextField)this.editorProperty().get();
    }

    public final ReadOnlyObjectProperty<TextField> editorProperty() {
        if (this.editor == null) {
            this.editor = new ReadOnlyObjectWrapper(this, "editor");
            this.editor.set(new ComboBoxListViewSkin.FakeFocusTextField());
        }
        return this.editor.getReadOnlyProperty();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new DatePickerSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return DatePicker.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final String country = Locale.getDefault(Locale.Category.FORMAT).getCountry();
        private static final CssMetaData<DatePicker, Boolean> SHOW_WEEK_NUMBERS = new CssMetaData<DatePicker, Boolean>("-fx-show-week-numbers", BooleanConverter.getInstance(), Boolean.valueOf(!country.isEmpty() && ControlResources.getNonTranslatableString("DatePicker.showWeekNumbers").contains(country))){

            @Override
            public boolean isSettable(DatePicker datePicker) {
                return datePicker.showWeekNumbers == null || !datePicker.showWeekNumbers.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(DatePicker datePicker) {
                return (StyleableProperty)((Object)datePicker.showWeekNumbersProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(arrayList, SHOW_WEEK_NUMBERS);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

