/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.TreeTableCellSkin;
import java.lang.ref.WeakReference;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;

public class TreeTableCell<S, T>
extends IndexedCell<T> {
    private boolean itemDirty = false;
    private ListChangeListener<TreeTablePosition<S, ?>> selectedListener = new ListChangeListener<TreeTablePosition<S, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TreeTablePosition<S, ?>> change) {
            TreeTableCell.this.updateSelection();
        }
    };
    private final InvalidationListener focusedListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TreeTableCell.this.updateFocus();
        }
    };
    private final InvalidationListener tableRowUpdateObserver = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TreeTableCell.this.itemDirty = true;
            TreeTableCell.this.requestLayout();
        }
    };
    private final InvalidationListener editingListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TreeTableCell.this.updateEditing();
        }
    };
    private ListChangeListener<TreeTableColumn<S, ?>> visibleLeafColumnsListener = new ListChangeListener<TreeTableColumn<S, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TreeTableColumn<S, ?>> change) {
            TreeTableCell.this.updateColumnIndex();
        }
    };
    private ListChangeListener<String> columnStyleClassListener = new ListChangeListener<String>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends String> change) {
            while (change.next()) {
                if (change.wasRemoved()) {
                    TreeTableCell.this.getStyleClass().removeAll((Collection<?>)change.getRemoved());
                }
                if (!change.wasAdded()) continue;
                TreeTableCell.this.getStyleClass().addAll((Collection<String>)change.getAddedSubList());
            }
        }
    };
    private final InvalidationListener rootPropertyListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TreeTableCell.this.updateItem();
        }
    };
    private final WeakListChangeListener<TreeTablePosition<S, ?>> weakSelectedListener = new WeakListChangeListener(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weaktableRowUpdateObserver = new WeakInvalidationListener(this.tableRowUpdateObserver);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakListChangeListener<TreeTableColumn<S, ?>> weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener<String> weakColumnStyleClassListener = new WeakListChangeListener<String>(this.columnStyleClassListener);
    private final WeakInvalidationListener weakRootPropertyListener = new WeakInvalidationListener(this.rootPropertyListener);
    private ReadOnlyObjectWrapper<TreeTableColumn<S, T>> treeTableColumn = new ReadOnlyObjectWrapper<TreeTableColumn<S, T>>(this, "treeTableColumn"){

        @Override
        protected void invalidated() {
            TreeTableCell.this.updateColumnIndex();
        }
    };
    private ReadOnlyObjectWrapper<TreeTableView<S>> treeTableView;
    private ReadOnlyObjectWrapper<TreeTableRow<S>> treeTableRow = new ReadOnlyObjectWrapper(this, "treeTableRow");
    private int index = -1;
    private boolean isLastVisibleColumn = false;
    private int columnIndex = -1;
    private boolean updateEditingIndex = true;
    private ObservableValue<T> currentObservableValue = null;
    private boolean isFirstRun = true;
    private static final String DEFAULT_STYLE_CLASS = "tree-table-cell";
    private static final PseudoClass PSEUDO_CLASS_LAST_VISIBLE = PseudoClass.getPseudoClass("last-visible");

    public TreeTableCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.updateColumnIndex();
    }

    public final ReadOnlyObjectProperty<TreeTableColumn<S, T>> tableColumnProperty() {
        return this.treeTableColumn.getReadOnlyProperty();
    }

    private void setTableColumn(TreeTableColumn<S, T> treeTableColumn) {
        this.treeTableColumn.set(treeTableColumn);
    }

    public final TreeTableColumn<S, T> getTableColumn() {
        return (TreeTableColumn)this.treeTableColumn.get();
    }

    private void setTreeTableView(TreeTableView<S> treeTableView) {
        this.treeTableViewPropertyImpl().set(treeTableView);
    }

    public final TreeTableView<S> getTreeTableView() {
        return this.treeTableView == null ? null : (TreeTableView)this.treeTableView.get();
    }

    public final ReadOnlyObjectProperty<TreeTableView<S>> treeTableViewProperty() {
        return this.treeTableViewPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TreeTableView<S>> treeTableViewPropertyImpl() {
        if (this.treeTableView == null) {
            this.treeTableView = new ReadOnlyObjectWrapper<TreeTableView<S>>(this, "treeTableView"){
                private WeakReference<TreeTableView<S>> weakTableViewRef;

                @Override
                protected void invalidated() {
                    TreeTableView.TreeTableViewFocusModel treeTableViewFocusModel;
                    TreeTableView.TreeTableViewSelectionModel treeTableViewSelectionModel;
                    TreeTableView treeTableView;
                    if (this.weakTableViewRef != null && (treeTableView = (TreeTableView)this.weakTableViewRef.get()) != null) {
                        treeTableViewSelectionModel = treeTableView.getSelectionModel();
                        if (treeTableViewSelectionModel != null) {
                            treeTableViewSelectionModel.getSelectedCells().removeListener(TreeTableCell.this.weakSelectedListener);
                        }
                        if ((treeTableViewFocusModel = treeTableView.getFocusModel()) != null) {
                            treeTableViewFocusModel.focusedCellProperty().removeListener(TreeTableCell.this.weakFocusedListener);
                        }
                        treeTableView.editingCellProperty().removeListener(TreeTableCell.this.weakEditingListener);
                        treeTableView.getVisibleLeafColumns().removeListener(TreeTableCell.this.weakVisibleLeafColumnsListener);
                        treeTableView.rootProperty().removeListener(TreeTableCell.this.weakRootPropertyListener);
                    }
                    if ((treeTableView = (TreeTableView)this.get()) != null) {
                        treeTableViewSelectionModel = treeTableView.getSelectionModel();
                        if (treeTableViewSelectionModel != null) {
                            treeTableViewSelectionModel.getSelectedCells().addListener(TreeTableCell.this.weakSelectedListener);
                        }
                        if ((treeTableViewFocusModel = treeTableView.getFocusModel()) != null) {
                            treeTableViewFocusModel.focusedCellProperty().addListener(TreeTableCell.this.weakFocusedListener);
                        }
                        treeTableView.editingCellProperty().addListener(TreeTableCell.this.weakEditingListener);
                        treeTableView.getVisibleLeafColumns().addListener(TreeTableCell.this.weakVisibleLeafColumnsListener);
                        treeTableView.rootProperty().addListener(TreeTableCell.this.weakRootPropertyListener);
                        this.weakTableViewRef = new WeakReference<TreeTableView>(treeTableView);
                    }
                    TreeTableCell.this.updateColumnIndex();
                }
            };
        }
        return this.treeTableView;
    }

    private void setTreeTableRow(TreeTableRow<S> treeTableRow) {
        this.treeTableRow.set(treeTableRow);
    }

    public final TreeTableRow<S> getTreeTableRow() {
        return (TreeTableRow)this.treeTableRow.get();
    }

    public final ReadOnlyObjectProperty<TreeTableRow<S>> tableRowProperty() {
        return this.treeTableRow;
    }

    @Override
    public void startEdit() {
        if (this.isEditing()) {
            return;
        }
        TreeTableView<S> treeTableView = this.getTreeTableView();
        TreeTableColumn<S, T> treeTableColumn = this.getTableColumn();
        if (!this.isEditable() || treeTableView != null && !treeTableView.isEditable() || treeTableColumn != null && !this.getTableColumn().isEditable()) {
            return;
        }
        this.updateItem();
        super.startEdit();
        TreeTablePosition<S, ?> treeTablePosition = treeTableView.getEditingCell();
        if (treeTableColumn != null) {
            TreeTableColumn.CellEditEvent<S, Object> cellEditEvent = new TreeTableColumn.CellEditEvent<S, Object>(treeTableView, treeTablePosition, TreeTableColumn.editStartEvent(), null);
            Event.fireEvent(treeTableColumn, cellEditEvent);
        }
    }

    @Override
    public void commitEdit(T t) {
        if (!this.isEditing()) {
            return;
        }
        TreeTableView treeTableView = this.getTreeTableView();
        if (treeTableView != null) {
            TreeTablePosition<S, ?> treeTablePosition = treeTableView.getEditingCell();
            TreeTableColumn.CellEditEvent cellEditEvent = new TreeTableColumn.CellEditEvent(treeTableView, treeTablePosition, TreeTableColumn.editCommitEvent(), t);
            Event.fireEvent(this.getTableColumn(), cellEditEvent);
        }
        super.commitEdit(t);
        this.updateItem(t, false);
        if (treeTableView != null) {
            treeTableView.edit(-1, null);
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(treeTableView);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        TreeTableView treeTableView = this.getTreeTableView();
        super.cancelEdit();
        if (treeTableView != null) {
            TreeTablePosition<S, ?> treeTablePosition = treeTableView.getEditingCell();
            if (this.updateEditingIndex) {
                treeTableView.edit(-1, null);
            }
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(treeTableView);
            TreeTableColumn.CellEditEvent<S, Object> cellEditEvent = new TreeTableColumn.CellEditEvent<S, Object>(treeTableView, treeTablePosition, TreeTableColumn.editCancelEvent(), null);
            Event.fireEvent(this.getTableColumn(), cellEditEvent);
        }
    }

    @Override
    public void updateSelected(boolean bl) {
        if (this.getTreeTableRow() == null || this.getTreeTableRow().isEmpty()) {
            return;
        }
        this.setSelected(bl);
    }

    @Override
    void indexChanged() {
        super.indexChanged();
        int n = this.index;
        super.indexChanged();
        this.index = this.getIndex();
        if (!this.isEditing() || this.index != n) {
            this.updateItem();
            this.updateSelection();
            this.updateFocus();
        }
    }

    private void updateColumnIndex() {
        TreeTableView<S> treeTableView = this.getTreeTableView();
        TreeTableColumn<S, T> treeTableColumn = this.getTableColumn();
        this.columnIndex = treeTableView == null || treeTableColumn == null ? -1 : treeTableView.getVisibleLeafIndex(treeTableColumn);
        this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == treeTableView.getVisibleLeafColumns().size() - 1;
        this.pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE, this.isLastVisibleColumn);
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        boolean bl = this.isSelected();
        if (!this.isInCellSelectionMode()) {
            if (bl) {
                this.updateSelected(false);
            }
            return;
        }
        TreeTableView<S> treeTableView = this.getTreeTableView();
        if (this.getIndex() == -1 || treeTableView == null) {
            return;
        }
        TreeTableView.TreeTableViewSelectionModel<S> treeTableViewSelectionModel = treeTableView.getSelectionModel();
        if (treeTableViewSelectionModel == null) {
            return;
        }
        boolean bl2 = treeTableViewSelectionModel.isSelected(this.getIndex(), this.getTableColumn());
        if (bl == bl2) {
            return;
        }
        this.updateSelected(bl2);
    }

    private void updateFocus() {
        boolean bl = this.isFocused();
        if (!this.isInCellSelectionMode()) {
            if (bl) {
                this.setFocused(false);
            }
            return;
        }
        TreeTableView<S> treeTableView = this.getTreeTableView();
        if (this.getIndex() == -1 || treeTableView == null) {
            return;
        }
        TreeTableView.TreeTableViewFocusModel<S> treeTableViewFocusModel = treeTableView.getFocusModel();
        if (treeTableViewFocusModel == null) {
            return;
        }
        boolean bl2 = treeTableViewFocusModel != null && treeTableViewFocusModel.isFocused(this.getIndex(), this.getTableColumn());
        this.setFocused(bl2);
    }

    private void updateEditing() {
        TreeTableView<S> treeTableView = this.getTreeTableView();
        if (this.getIndex() == -1 || treeTableView == null) {
            return;
        }
        TreeTablePosition<S, ?> treeTablePosition = treeTableView.getEditingCell();
        boolean bl = this.match(treeTablePosition);
        if (bl && !this.isEditing()) {
            this.startEdit();
        } else if (!bl && this.isEditing()) {
            this.updateEditingIndex = false;
            this.cancelEdit();
            this.updateEditingIndex = true;
        }
    }

    private boolean match(TreeTablePosition treeTablePosition) {
        return treeTablePosition != null && treeTablePosition.getRow() == this.getIndex() && treeTablePosition.getTableColumn() == this.getTableColumn();
    }

    private boolean isInCellSelectionMode() {
        TreeTableView<S> treeTableView = this.getTreeTableView();
        if (treeTableView == null) {
            return false;
        }
        TreeTableView.TreeTableViewSelectionModel<S> treeTableViewSelectionModel = treeTableView.getSelectionModel();
        return treeTableViewSelectionModel != null && treeTableViewSelectionModel.isCellSelectionEnabled();
    }

    private void updateItem() {
        boolean bl;
        if (this.currentObservableValue != null) {
            this.currentObservableValue.removeListener(this.weaktableRowUpdateObserver);
        }
        TreeTableView<S> treeTableView = this.getTreeTableView();
        TreeTableColumn<S, T> treeTableColumn = this.getTableColumn();
        int n = treeTableView == null ? -1 : this.getTreeTableView().getExpandedItemCount();
        int n2 = this.getIndex();
        boolean bl2 = this.isEmpty();
        Object t = this.getItem();
        boolean bl3 = bl = n2 >= n;
        if (bl || n2 < 0 || this.columnIndex < 0 || !this.isVisible() || treeTableColumn == null || !treeTableColumn.isVisible() || treeTableView.getRoot() == null) {
            if (!bl2 && t != null || this.isFirstRun || bl) {
                this.updateItem(null, true);
                this.isFirstRun = false;
            }
            return;
        }
        this.currentObservableValue = treeTableColumn.getCellObservableValue(n2);
        Object t2 = this.currentObservableValue == null ? null : (Object)this.currentObservableValue.getValue();
        this.updateItem(t2, false);
        if (this.currentObservableValue == null) {
            return;
        }
        this.currentObservableValue.addListener(this.weaktableRowUpdateObserver);
    }

    @Override
    protected void layoutChildren() {
        if (this.itemDirty) {
            this.updateItem();
            this.itemDirty = false;
        }
        super.layoutChildren();
    }

    public final void updateTreeTableView(TreeTableView<S> treeTableView) {
        this.setTreeTableView(treeTableView);
    }

    public final void updateTreeTableRow(TreeTableRow<S> treeTableRow) {
        this.setTreeTableRow(treeTableRow);
    }

    public final void updateTreeTableColumn(TreeTableColumn<S, T> treeTableColumn) {
        TreeTableColumn<S, T> treeTableColumn2 = this.getTableColumn();
        if (treeTableColumn2 != null) {
            treeTableColumn2.getStyleClass().removeListener(this.weakColumnStyleClassListener);
            this.getStyleClass().removeAll((Collection<?>)treeTableColumn2.getStyleClass());
        }
        this.setTableColumn(treeTableColumn);
        if (treeTableColumn != null) {
            this.getStyleClass().addAll((Collection<String>)treeTableColumn.getStyleClass());
            treeTableColumn.getStyleClass().addListener(this.weakColumnStyleClassListener);
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeTableCellSkin(this);
    }
}

