/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.WeakCache;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import sun.misc.ProxyGenerator;
import sun.misc.VM;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Class<?>[] constructorParams = new Class[]{InvocationHandler.class};
    private static final WeakCache<ClassLoader, Class<?>[], Class<?>> proxyClassCache = new WeakCache(new KeyFactory(), new ProxyClassFactory());
    protected InvocationHandler h;
    private static final Object key0 = new Object();

    private Proxy() {
    }

    protected Proxy(InvocationHandler invocationHandler) {
        Objects.requireNonNull(invocationHandler);
        this.h = invocationHandler;
    }

    @CallerSensitive
    public static Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... classArray) throws IllegalArgumentException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), classLoader, classArray);
        }
        return Proxy.getProxyClass0(classLoader, classArray);
    }

    private static void checkProxyAccess(Class<?> clazz, ClassLoader classLoader, Class<?> ... classArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ClassLoader classLoader2 = clazz.getClassLoader();
            if (VM.isSystemDomainLoader(classLoader) && !VM.isSystemDomainLoader(classLoader2)) {
                securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
            ReflectUtil.checkProxyPackageAccess(classLoader2, classArray);
        }
    }

    private static Class<?> getProxyClass0(ClassLoader classLoader, Class<?> ... classArray) {
        if (classArray.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        return proxyClassCache.get(classLoader, classArray);
    }

    @CallerSensitive
    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] classArray, InvocationHandler invocationHandler) throws IllegalArgumentException {
        Objects.requireNonNull(invocationHandler);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), classLoader, classArray);
        }
        Class<?> clazz = Proxy.getProxyClass0(classLoader, classArray);
        try {
            if (securityManager != null) {
                Proxy.checkNewProxyPermission(Reflection.getCallerClass(), clazz);
            }
            final Constructor<?> constructor = clazz.getConstructor(constructorParams);
            InvocationHandler invocationHandler2 = invocationHandler;
            if (!Modifier.isPublic(clazz.getModifiers())) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        constructor.setAccessible(true);
                        return null;
                    }
                });
            }
            return constructor.newInstance(invocationHandler);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException.toString(), reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new InternalError(throwable.toString(), throwable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString(), noSuchMethodException);
        }
    }

    private static void checkNewProxyPermission(Class<?> clazz, Class<?> clazz2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && ReflectUtil.isNonPublicProxyClass(clazz2)) {
            String string;
            ClassLoader classLoader = clazz.getClassLoader();
            ClassLoader classLoader2 = clazz2.getClassLoader();
            int n = clazz2.getName().lastIndexOf(46);
            String string2 = n == -1 ? "" : clazz2.getName().substring(0, n);
            n = clazz.getName().lastIndexOf(46);
            String string3 = string = n == -1 ? "" : clazz.getName().substring(0, n);
            if (classLoader2 != classLoader || !string2.equals(string)) {
                securityManager.checkPermission(new ReflectPermission("newProxyInPackage." + string2));
            }
        }
    }

    public static boolean isProxyClass(Class<?> clazz) {
        return Proxy.class.isAssignableFrom(clazz) && proxyClassCache.containsValue(clazz);
    }

    @CallerSensitive
    public static InvocationHandler getInvocationHandler(Object object) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy proxy = (Proxy)object;
        InvocationHandler invocationHandler = proxy.h;
        if (System.getSecurityManager() != null) {
            Class<?> clazz = invocationHandler.getClass();
            Class<?> clazz2 = Reflection.getCallerClass();
            if (ReflectUtil.needsPackageAccessCheck(clazz2.getClassLoader(), clazz.getClassLoader())) {
                ReflectUtil.checkPackageAccess(clazz);
            }
        }
        return invocationHandler;
    }

    private static native Class<?> defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);

    private static final class Key1
    extends WeakReference<Class<?>> {
        private final int hash;

        Key1(Class<?> clazz) {
            super(clazz);
            this.hash = clazz.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Class clazz;
            return this == object || object != null && object.getClass() == Key1.class && (clazz = (Class)this.get()) != null && clazz == ((Key1)object).get();
        }
    }

    private static final class Key2
    extends WeakReference<Class<?>> {
        private final int hash;
        private final WeakReference<Class<?>> ref2;

        Key2(Class<?> clazz, Class<?> clazz2) {
            super(clazz);
            this.hash = 31 * clazz.hashCode() + clazz2.hashCode();
            this.ref2 = new WeakReference(clazz2);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Class clazz;
            Class clazz2;
            return this == object || object != null && object.getClass() == Key2.class && (clazz2 = (Class)this.get()) != null && clazz2 == ((Key2)object).get() && (clazz = (Class)this.ref2.get()) != null && clazz == ((Key2)object).ref2.get();
        }
    }

    private static final class KeyFactory
    implements BiFunction<ClassLoader, Class<?>[], Object> {
        private KeyFactory() {
        }

        @Override
        public Object apply(ClassLoader classLoader, Class<?>[] classArray) {
            switch (classArray.length) {
                case 1: {
                    return new Key1(classArray[0]);
                }
                case 2: {
                    return new Key2(classArray[0], classArray[1]);
                }
                case 0: {
                    return key0;
                }
            }
            return new KeyX(classArray);
        }
    }

    private static final class KeyX {
        private final int hash;
        private final WeakReference<Class<?>>[] refs;

        KeyX(Class<?>[] classArray) {
            this.hash = Arrays.hashCode(classArray);
            this.refs = new WeakReference[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                this.refs[i] = new WeakReference(classArray[i]);
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            return this == object || object != null && object.getClass() == KeyX.class && KeyX.equals(this.refs, ((KeyX)object).refs);
        }

        private static boolean equals(WeakReference<Class<?>>[] weakReferenceArray, WeakReference<Class<?>>[] weakReferenceArray2) {
            if (weakReferenceArray.length != weakReferenceArray2.length) {
                return false;
            }
            for (int i = 0; i < weakReferenceArray.length; ++i) {
                Class clazz = (Class)weakReferenceArray[i].get();
                if (clazz != null && clazz == weakReferenceArray2[i].get()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class ProxyClassFactory
    implements BiFunction<ClassLoader, Class<?>[], Class<?>> {
        private static final String proxyClassNamePrefix = "$Proxy";
        private static final AtomicLong nextUniqueNumber = new AtomicLong();

        private ProxyClassFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> apply(ClassLoader classLoader, Class<?>[] classArray) {
            void var4_9;
            void var4_6;
            Class<?> clazz4;
            IdentityHashMap identityHashMap = new IdentityHashMap(classArray.length);
            for (Class<?> clazz2 : classArray) {
                Class<?> clazz3 = null;
                try {
                    clazz3 = Class.forName(clazz2.getName(), false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz3 != clazz2) {
                    throw new IllegalArgumentException(clazz2 + " is not visible from class loader");
                }
                if (!clazz3.isInterface()) {
                    throw new IllegalArgumentException(clazz3.getName() + " is not an interface");
                }
                if (identityHashMap.put(clazz3, Boolean.TRUE) == null) continue;
                throw new IllegalArgumentException("repeated interface: " + clazz3.getName());
            }
            Object var4_5 = null;
            int n = 17;
            for (Class<?> clazz4 : classArray) {
                String string;
                int n2 = clazz4.getModifiers();
                if (Modifier.isPublic(n2)) continue;
                n = 16;
                String string2 = clazz4.getName();
                int n3 = string2.lastIndexOf(46);
                String string3 = string = n3 == -1 ? "" : string2.substring(0, n3 + 1);
                if (var4_6 == null) {
                    String string4 = string;
                    continue;
                }
                if (string.equals(var4_6)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (var4_6 == null) {
                String string = "com.sun.proxy.";
            }
            long l = nextUniqueNumber.getAndIncrement();
            String string = (String)var4_9 + proxyClassNamePrefix + l;
            clazz4 = (Class<?>)ProxyGenerator.generateProxyClass(string, classArray, n);
            try {
                return Proxy.defineClass0(classLoader, string, (byte[])clazz4, 0, ((Object)clazz4).length);
            }
            catch (ClassFormatError classFormatError) {
                throw new IllegalArgumentException(classFormatError.toString());
            }
        }
    }
}

