/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetTime;
import java.time.Ser;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import java.util.Comparator;
import java.util.Objects;

public final class OffsetDateTime
implements Temporal,
TemporalAdjuster,
Comparable<OffsetDateTime>,
Serializable {
    public static final OffsetDateTime MIN = LocalDateTime.MIN.atOffset(ZoneOffset.MAX);
    public static final OffsetDateTime MAX = LocalDateTime.MAX.atOffset(ZoneOffset.MIN);
    private static final long serialVersionUID = 2287754244819255394L;
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;

    public static Comparator<OffsetDateTime> timeLineOrder() {
        return OffsetDateTime::compareInstant;
    }

    private static int compareInstant(OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2) {
        if (offsetDateTime.getOffset().equals(offsetDateTime2.getOffset())) {
            return offsetDateTime.toLocalDateTime().compareTo(offsetDateTime2.toLocalDateTime());
        }
        int n = Long.compare(offsetDateTime.toEpochSecond(), offsetDateTime2.toEpochSecond());
        if (n == 0) {
            n = offsetDateTime.toLocalTime().getNano() - offsetDateTime2.toLocalTime().getNano();
        }
        return n;
    }

    public static OffsetDateTime now() {
        return OffsetDateTime.now(Clock.systemDefaultZone());
    }

    public static OffsetDateTime now(ZoneId zoneId) {
        return OffsetDateTime.now(Clock.system(zoneId));
    }

    public static OffsetDateTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        return OffsetDateTime.ofInstant(instant, clock.getZone().getRules().getOffset(instant));
    }

    public static OffsetDateTime of(LocalDate localDate, LocalTime localTime, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime of(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.of(n, n2, n3, n4, n5, n6, n7);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime ofInstant(Instant instant, ZoneId zoneId) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), zoneOffset);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof OffsetDateTime) {
            return (OffsetDateTime)temporalAccessor;
        }
        try {
            ZoneOffset zoneOffset = ZoneOffset.from(temporalAccessor);
            try {
                LocalDateTime localDateTime = LocalDateTime.from(temporalAccessor);
                return OffsetDateTime.of(localDateTime, zoneOffset);
            }
            catch (DateTimeException dateTimeException) {
                Instant instant = Instant.from(temporalAccessor);
                return OffsetDateTime.ofInstant(instant, zoneOffset);
            }
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain OffsetDateTime from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName(), dateTimeException);
        }
    }

    public static OffsetDateTime parse(CharSequence charSequence) {
        return OffsetDateTime.parse(charSequence, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static OffsetDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.parse(charSequence, OffsetDateTime::from);
    }

    private OffsetDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        this.dateTime = Objects.requireNonNull(localDateTime, "dateTime");
        this.offset = Objects.requireNonNull(zoneOffset, "offset");
    }

    private OffsetDateTime with(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        if (this.dateTime == localDateTime && this.offset.equals(zoneOffset)) {
            return this;
        }
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        return temporalField instanceof ChronoField || temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit != ChronoUnit.FOREVER;
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.INSTANT_SECONDS || temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.dateTime.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    throw new UnsupportedTemporalTypeException("Invalid field 'InstantSeconds' for get() method, use getLong() instead");
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.get(temporalField);
        }
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetDateTime withOffsetSameLocal(ZoneOffset zoneOffset) {
        return this.with(this.dateTime, zoneOffset);
    }

    public OffsetDateTime withOffsetSameInstant(ZoneOffset zoneOffset) {
        if (zoneOffset.equals(this.offset)) {
            return this;
        }
        int n = zoneOffset.getTotalSeconds() - this.offset.getTotalSeconds();
        LocalDateTime localDateTime = this.dateTime.plusSeconds(n);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public LocalDateTime toLocalDateTime() {
        return this.dateTime;
    }

    public LocalDate toLocalDate() {
        return this.dateTime.toLocalDate();
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public int getMonthValue() {
        return this.dateTime.getMonthValue();
    }

    public Month getMonth() {
        return this.dateTime.getMonth();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    public LocalTime toLocalTime() {
        return this.dateTime.toLocalTime();
    }

    public int getHour() {
        return this.dateTime.getHour();
    }

    public int getMinute() {
        return this.dateTime.getMinute();
    }

    public int getSecond() {
        return this.dateTime.getSecond();
    }

    public int getNano() {
        return this.dateTime.getNano();
    }

    @Override
    public OffsetDateTime with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate || temporalAdjuster instanceof LocalTime || temporalAdjuster instanceof LocalDateTime) {
            return this.with(this.dateTime.with(temporalAdjuster), this.offset);
        }
        if (temporalAdjuster instanceof Instant) {
            return OffsetDateTime.ofInstant((Instant)temporalAdjuster, this.offset);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            return this.with(this.dateTime, (ZoneOffset)temporalAdjuster);
        }
        if (temporalAdjuster instanceof OffsetDateTime) {
            return (OffsetDateTime)temporalAdjuster;
        }
        return (OffsetDateTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public OffsetDateTime with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            switch (chronoField) {
                case INSTANT_SECONDS: {
                    return OffsetDateTime.ofInstant(Instant.ofEpochSecond(l, this.getNano()), this.offset);
                }
                case OFFSET_SECONDS: {
                    return this.with(this.dateTime, ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l)));
                }
            }
            return this.with(this.dateTime.with(temporalField, l), this.offset);
        }
        return temporalField.adjustInto(this, l);
    }

    public OffsetDateTime withYear(int n) {
        return this.with(this.dateTime.withYear(n), this.offset);
    }

    public OffsetDateTime withMonth(int n) {
        return this.with(this.dateTime.withMonth(n), this.offset);
    }

    public OffsetDateTime withDayOfMonth(int n) {
        return this.with(this.dateTime.withDayOfMonth(n), this.offset);
    }

    public OffsetDateTime withDayOfYear(int n) {
        return this.with(this.dateTime.withDayOfYear(n), this.offset);
    }

    public OffsetDateTime withHour(int n) {
        return this.with(this.dateTime.withHour(n), this.offset);
    }

    public OffsetDateTime withMinute(int n) {
        return this.with(this.dateTime.withMinute(n), this.offset);
    }

    public OffsetDateTime withSecond(int n) {
        return this.with(this.dateTime.withSecond(n), this.offset);
    }

    public OffsetDateTime withNano(int n) {
        return this.with(this.dateTime.withNano(n), this.offset);
    }

    public OffsetDateTime truncatedTo(TemporalUnit temporalUnit) {
        return this.with(this.dateTime.truncatedTo(temporalUnit), this.offset);
    }

    @Override
    public OffsetDateTime plus(TemporalAmount temporalAmount) {
        return (OffsetDateTime)temporalAmount.addTo(this);
    }

    @Override
    public OffsetDateTime plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.dateTime.plus(l, temporalUnit), this.offset);
        }
        return temporalUnit.addTo(this, l);
    }

    public OffsetDateTime plusYears(long l) {
        return this.with(this.dateTime.plusYears(l), this.offset);
    }

    public OffsetDateTime plusMonths(long l) {
        return this.with(this.dateTime.plusMonths(l), this.offset);
    }

    public OffsetDateTime plusWeeks(long l) {
        return this.with(this.dateTime.plusWeeks(l), this.offset);
    }

    public OffsetDateTime plusDays(long l) {
        return this.with(this.dateTime.plusDays(l), this.offset);
    }

    public OffsetDateTime plusHours(long l) {
        return this.with(this.dateTime.plusHours(l), this.offset);
    }

    public OffsetDateTime plusMinutes(long l) {
        return this.with(this.dateTime.plusMinutes(l), this.offset);
    }

    public OffsetDateTime plusSeconds(long l) {
        return this.with(this.dateTime.plusSeconds(l), this.offset);
    }

    public OffsetDateTime plusNanos(long l) {
        return this.with(this.dateTime.plusNanos(l), this.offset);
    }

    @Override
    public OffsetDateTime minus(TemporalAmount temporalAmount) {
        return (OffsetDateTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public OffsetDateTime minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public OffsetDateTime minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public OffsetDateTime minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    public OffsetDateTime minusWeeks(long l) {
        return l == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-l);
    }

    public OffsetDateTime minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public OffsetDateTime minusHours(long l) {
        return l == Long.MIN_VALUE ? this.plusHours(Long.MAX_VALUE).plusHours(1L) : this.plusHours(-l);
    }

    public OffsetDateTime minusMinutes(long l) {
        return l == Long.MIN_VALUE ? this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L) : this.plusMinutes(-l);
    }

    public OffsetDateTime minusSeconds(long l) {
        return l == Long.MIN_VALUE ? this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L) : this.plusSeconds(-l);
    }

    public OffsetDateTime minusNanos(long l) {
        return l == Long.MIN_VALUE ? this.plusNanos(Long.MAX_VALUE).plusNanos(1L) : this.plusNanos(-l);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return (R)this.getOffset();
        }
        if (temporalQuery == TemporalQueries.zoneId()) {
            return null;
        }
        if (temporalQuery == TemporalQueries.localDate()) {
            return (R)this.toLocalDate();
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return (R)this.toLocalTime();
        }
        if (temporalQuery == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return temporalQuery.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField.NANO_OF_DAY, this.toLocalTime().toNanoOfDay()).with(ChronoField.OFFSET_SECONDS, this.getOffset().getTotalSeconds());
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        OffsetDateTime offsetDateTime = OffsetDateTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            offsetDateTime = offsetDateTime.withOffsetSameInstant(this.offset);
            return this.dateTime.until(offsetDateTime.dateTime, temporalUnit);
        }
        return temporalUnit.between(this, offsetDateTime);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public ZonedDateTime atZoneSameInstant(ZoneId zoneId) {
        return ZonedDateTime.ofInstant(this.dateTime, this.offset, zoneId);
    }

    public ZonedDateTime atZoneSimilarLocal(ZoneId zoneId) {
        return ZonedDateTime.ofLocal(this.dateTime, zoneId, this.offset);
    }

    public OffsetTime toOffsetTime() {
        return OffsetTime.of(this.dateTime.toLocalTime(), this.offset);
    }

    public ZonedDateTime toZonedDateTime() {
        return ZonedDateTime.of(this.dateTime, this.offset);
    }

    public Instant toInstant() {
        return this.dateTime.toInstant(this.offset);
    }

    public long toEpochSecond() {
        return this.dateTime.toEpochSecond(this.offset);
    }

    @Override
    public int compareTo(OffsetDateTime offsetDateTime) {
        int n = OffsetDateTime.compareInstant(this, offsetDateTime);
        if (n == 0) {
            n = this.toLocalDateTime().compareTo(offsetDateTime.toLocalDateTime());
        }
        return n;
    }

    public boolean isAfter(OffsetDateTime offsetDateTime) {
        long l;
        long l2 = this.toEpochSecond();
        return l2 > (l = offsetDateTime.toEpochSecond()) || l2 == l && this.toLocalTime().getNano() > offsetDateTime.toLocalTime().getNano();
    }

    public boolean isBefore(OffsetDateTime offsetDateTime) {
        long l;
        long l2 = this.toEpochSecond();
        return l2 < (l = offsetDateTime.toEpochSecond()) || l2 == l && this.toLocalTime().getNano() < offsetDateTime.toLocalTime().getNano();
    }

    public boolean isEqual(OffsetDateTime offsetDateTime) {
        return this.toEpochSecond() == offsetDateTime.toEpochSecond() && this.toLocalTime().getNano() == offsetDateTime.toLocalTime().getNano();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return this.dateTime.equals(offsetDateTime.dateTime) && this.offset.equals(offsetDateTime.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.dateTime.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.dateTime.toString() + this.offset.toString();
    }

    private Object writeReplace() {
        return new Ser(10, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.dateTime.writeExternal(objectOutput);
        this.offset.writeExternal(objectOutput);
    }

    static OffsetDateTime readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        LocalDateTime localDateTime = LocalDateTime.readExternal(objectInput);
        ZoneOffset zoneOffset = ZoneOffset.readExternal(objectInput);
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }
}

