/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.NetworkInterface;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Random;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import sun.misc.Unsafe;
import sun.security.action.GetPropertyAction;

public class ThreadLocalRandom
extends Random {
    private static final AtomicInteger probeGenerator = new AtomicInteger();
    private static final AtomicLong seeder = new AtomicLong(ThreadLocalRandom.initialSeed());
    private static final long GAMMA = -7046029254386353131L;
    private static final int PROBE_INCREMENT = -1640531527;
    private static final long SEEDER_INCREMENT = -4942790177534073029L;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private static final ThreadLocal<Double> nextLocalGaussian = new ThreadLocal();
    boolean initialized = true;
    static final ThreadLocalRandom instance = new ThreadLocalRandom();
    static final String BadBound = "bound must be positive";
    static final String BadRange = "bound must be greater than origin";
    static final String BadSize = "size must be non-negative";
    private static final long serialVersionUID = -5851777807851030925L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rnd", Long.TYPE), new ObjectStreamField("initialized", Boolean.TYPE)};
    private static final Unsafe UNSAFE;
    private static final long SEED;
    private static final long PROBE;
    private static final long SECONDARY;

    private static long initialSeed() {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.util.secureRandomSeed"));
        if (string != null && string.equalsIgnoreCase("true")) {
            byte[] byArray = SecureRandom.getSeed(8);
            long l = (long)byArray[0] & 0xFFL;
            for (int i = 1; i < 8; ++i) {
                l = l << 8 | (long)byArray[i] & 0xFFL;
            }
            return l;
        }
        long l = 0L;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isVirtual()) continue;
                byte[] byArray = networkInterface.getHardwareAddress();
                if (byArray != null) {
                    int n = byArray.length;
                    int n2 = Math.min(n >>> 1, 4);
                    for (int i = 0; i < n2; ++i) {
                        l = l << 16 ^ (long)(byArray[i] << 8) ^ (long)byArray[n - 1 - i];
                    }
                    if (n2 < 4) {
                        l = l << 8 ^ (long)byArray[n - 1 - n2];
                    }
                    l = ThreadLocalRandom.mix64(l);
                } else if (!bl) {
                    bl = true;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l ^ ThreadLocalRandom.mix64(System.currentTimeMillis()) ^ ThreadLocalRandom.mix64(System.nanoTime());
    }

    private static long mix64(long l) {
        l = (l ^ l >>> 33) * -49064778989728563L;
        l = (l ^ l >>> 33) * -4265267296055464877L;
        return l ^ l >>> 33;
    }

    private static int mix32(long l) {
        l = (l ^ l >>> 33) * -49064778989728563L;
        return (int)((l ^ l >>> 33) * -4265267296055464877L >>> 32);
    }

    private ThreadLocalRandom() {
    }

    static final void localInit() {
        int n = probeGenerator.addAndGet(-1640531527);
        int n2 = n == 0 ? 1 : n;
        long l = ThreadLocalRandom.mix64(seeder.getAndAdd(-4942790177534073029L));
        Thread thread = Thread.currentThread();
        UNSAFE.putLong((Object)thread, SEED, l);
        UNSAFE.putInt((Object)thread, PROBE, n2);
    }

    public static ThreadLocalRandom current() {
        if (UNSAFE.getInt((Object)Thread.currentThread(), PROBE) == 0) {
            ThreadLocalRandom.localInit();
        }
        return instance;
    }

    @Override
    public void setSeed(long l) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
    }

    final long nextSeed() {
        Thread thread = Thread.currentThread();
        long l = UNSAFE.getLong((Object)thread, SEED) + -7046029254386353131L;
        UNSAFE.putLong((Object)thread, SEED, l);
        return l;
    }

    @Override
    protected int next(int n) {
        return (int)(ThreadLocalRandom.mix64(this.nextSeed()) >>> 64 - n);
    }

    final long internalNextLong(long l, long l2) {
        long l3 = ThreadLocalRandom.mix64(this.nextSeed());
        if (l < l2) {
            long l4 = l2 - l;
            long l5 = l4 - 1L;
            if ((l4 & l5) == 0L) {
                l3 = (l3 & l5) + l;
            } else if (l4 > 0L) {
                long l6 = l3 >>> 1;
                while (l6 + l5 - (l3 = l6 % l4) < 0L) {
                    l6 = ThreadLocalRandom.mix64(this.nextSeed()) >>> 1;
                }
                l3 += l;
            } else {
                while (l3 < l || l3 >= l2) {
                    l3 = ThreadLocalRandom.mix64(this.nextSeed());
                }
            }
        }
        return l3;
    }

    final int internalNextInt(int n, int n2) {
        int n3 = ThreadLocalRandom.mix32(this.nextSeed());
        if (n < n2) {
            int n4 = n2 - n;
            int n5 = n4 - 1;
            if ((n4 & n5) == 0) {
                n3 = (n3 & n5) + n;
            } else if (n4 > 0) {
                int n6 = n3 >>> 1;
                while (n6 + n5 - (n3 = n6 % n4) < 0) {
                    n6 = ThreadLocalRandom.mix32(this.nextSeed()) >>> 1;
                }
                n3 += n;
            } else {
                while (n3 < n || n3 >= n2) {
                    n3 = ThreadLocalRandom.mix32(this.nextSeed());
                }
            }
        }
        return n3;
    }

    final double internalNextDouble(double d, double d2) {
        double d3 = (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
        if (d < d2 && (d3 = d3 * (d2 - d) + d) >= d2) {
            d3 = Double.longBitsToDouble(Double.doubleToLongBits(d2) - 1L);
        }
        return d3;
    }

    @Override
    public int nextInt() {
        return ThreadLocalRandom.mix32(this.nextSeed());
    }

    @Override
    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(BadBound);
        }
        int n2 = ThreadLocalRandom.mix32(this.nextSeed());
        int n3 = n - 1;
        if ((n & n3) == 0) {
            n2 &= n3;
        } else {
            int n4 = n2 >>> 1;
            while (n4 + n3 - (n2 = n4 % n) < 0) {
                n4 = ThreadLocalRandom.mix32(this.nextSeed()) >>> 1;
            }
        }
        return n2;
    }

    public int nextInt(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextInt(n, n2);
    }

    @Override
    public long nextLong() {
        return ThreadLocalRandom.mix64(this.nextSeed());
    }

    public long nextLong(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(BadBound);
        }
        long l2 = ThreadLocalRandom.mix64(this.nextSeed());
        long l3 = l - 1L;
        if ((l & l3) == 0L) {
            l2 &= l3;
        } else {
            long l4 = l2 >>> 1;
            while (l4 + l3 - (l2 = l4 % l) < 0L) {
                l4 = ThreadLocalRandom.mix64(this.nextSeed()) >>> 1;
            }
        }
        return l2;
    }

    public long nextLong(long l, long l2) {
        if (l >= l2) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextLong(l, l2);
    }

    @Override
    public double nextDouble() {
        return (double)(ThreadLocalRandom.mix64(this.nextSeed()) >>> 11) * (double)1.110223E-16f;
    }

    public double nextDouble(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException(BadBound);
        }
        double d2 = (double)(ThreadLocalRandom.mix64(this.nextSeed()) >>> 11) * (double)1.110223E-16f * d;
        return d2 < d ? d2 : Double.longBitsToDouble(Double.doubleToLongBits(d) - 1L);
    }

    public double nextDouble(double d, double d2) {
        if (!(d < d2)) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextDouble(d, d2);
    }

    @Override
    public boolean nextBoolean() {
        return ThreadLocalRandom.mix32(this.nextSeed()) < 0;
    }

    @Override
    public float nextFloat() {
        return (float)(ThreadLocalRandom.mix32(this.nextSeed()) >>> 8) * 5.9604645E-8f;
    }

    @Override
    public double nextGaussian() {
        double d;
        double d2;
        double d3;
        Double d4 = nextLocalGaussian.get();
        if (d4 != null) {
            nextLocalGaussian.set(null);
            return d4;
        }
        while ((d3 = (d2 = 2.0 * this.nextDouble() - 1.0) * d2 + (d = 2.0 * this.nextDouble() - 1.0) * d) >= 1.0 || d3 == 0.0) {
        }
        double d5 = StrictMath.sqrt(-2.0 * StrictMath.log(d3) / d3);
        nextLocalGaussian.set(new Double(d * d5));
        return d2 * d5;
    }

    @Override
    public IntStream ints(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, l, Integer.MAX_VALUE, 0), false);
    }

    @Override
    public IntStream ints() {
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, Long.MAX_VALUE, Integer.MAX_VALUE, 0), false);
    }

    @Override
    public IntStream ints(long l, int n, int n2) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (n >= n2) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, l, n, n2), false);
    }

    @Override
    public IntStream ints(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, Long.MAX_VALUE, n, n2), false);
    }

    @Override
    public LongStream longs(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, l, Long.MAX_VALUE, 0L), false);
    }

    @Override
    public LongStream longs() {
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L), false);
    }

    @Override
    public LongStream longs(long l, long l2, long l3) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (l2 >= l3) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, l, l2, l3), false);
    }

    @Override
    public LongStream longs(long l, long l2) {
        if (l >= l2) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, Long.MAX_VALUE, l, l2), false);
    }

    @Override
    public DoubleStream doubles(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, l, Double.MAX_VALUE, 0.0), false);
    }

    @Override
    public DoubleStream doubles() {
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, Long.MAX_VALUE, Double.MAX_VALUE, 0.0), false);
    }

    @Override
    public DoubleStream doubles(long l, double d, double d2) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (!(d < d2)) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, l, d, d2), false);
    }

    @Override
    public DoubleStream doubles(double d, double d2) {
        if (!(d < d2)) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, Long.MAX_VALUE, d, d2), false);
    }

    static final int getProbe() {
        return UNSAFE.getInt((Object)Thread.currentThread(), PROBE);
    }

    static final int advanceProbe(int n) {
        n ^= n << 13;
        n ^= n >>> 17;
        n ^= n << 5;
        UNSAFE.putInt((Object)Thread.currentThread(), PROBE, n);
        return n;
    }

    static final int nextSecondarySeed() {
        Thread thread = Thread.currentThread();
        int n = UNSAFE.getInt((Object)thread, SECONDARY);
        if (n != 0) {
            n ^= n << 13;
            n ^= n >>> 17;
            n ^= n << 5;
        } else {
            ThreadLocalRandom.localInit();
            n = (int)UNSAFE.getLong((Object)thread, SEED);
            if (n == 0) {
                n = 1;
            }
        }
        UNSAFE.putInt((Object)thread, SECONDARY, n);
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("rnd", UNSAFE.getLong((Object)Thread.currentThread(), SEED));
        putField.put("initialized", true);
        objectOutputStream.writeFields();
    }

    private Object readResolve() {
        return ThreadLocalRandom.current();
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> clazz = Thread.class;
            SEED = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocalRandomSeed"));
            PROBE = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocalRandomProbe"));
            SECONDARY = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocalRandomSecondarySeed"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class RandomDoublesSpliterator
    implements Spliterator.OfDouble {
        long index;
        final long fence;
        final double origin;
        final double bound;

        RandomDoublesSpliterator(long l, long l2, double d, double d2) {
            this.index = l;
            this.fence = l2;
            this.origin = d;
            this.bound = d2;
        }

        @Override
        public RandomDoublesSpliterator trySplit() {
            RandomDoublesSpliterator randomDoublesSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            if (l2 <= l) {
                randomDoublesSpliterator = null;
            } else {
                this.index = l2;
                RandomDoublesSpliterator randomDoublesSpliterator2 = new RandomDoublesSpliterator(l, this.index, this.origin, this.bound);
                randomDoublesSpliterator = randomDoublesSpliterator2;
            }
            return randomDoublesSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            if (doubleConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                doubleConsumer.accept(ThreadLocalRandom.current().internalNextDouble(this.origin, this.bound));
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            if (doubleConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                this.index = l2;
                double d = this.origin;
                double d2 = this.bound;
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                do {
                    doubleConsumer.accept(threadLocalRandom.internalNextDouble(d, d2));
                } while (++l < l2);
            }
        }
    }

    static final class RandomIntsSpliterator
    implements Spliterator.OfInt {
        long index;
        final long fence;
        final int origin;
        final int bound;

        RandomIntsSpliterator(long l, long l2, int n, int n2) {
            this.index = l;
            this.fence = l2;
            this.origin = n;
            this.bound = n2;
        }

        @Override
        public RandomIntsSpliterator trySplit() {
            RandomIntsSpliterator randomIntsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            if (l2 <= l) {
                randomIntsSpliterator = null;
            } else {
                this.index = l2;
                RandomIntsSpliterator randomIntsSpliterator2 = new RandomIntsSpliterator(l, this.index, this.origin, this.bound);
                randomIntsSpliterator = randomIntsSpliterator2;
            }
            return randomIntsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                intConsumer.accept(ThreadLocalRandom.current().internalNextInt(this.origin, this.bound));
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                this.index = l2;
                int n = this.origin;
                int n2 = this.bound;
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                do {
                    intConsumer.accept(threadLocalRandom.internalNextInt(n, n2));
                } while (++l < l2);
            }
        }
    }

    static final class RandomLongsSpliterator
    implements Spliterator.OfLong {
        long index;
        final long fence;
        final long origin;
        final long bound;

        RandomLongsSpliterator(long l, long l2, long l3, long l4) {
            this.index = l;
            this.fence = l2;
            this.origin = l3;
            this.bound = l4;
        }

        @Override
        public RandomLongsSpliterator trySplit() {
            RandomLongsSpliterator randomLongsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            if (l2 <= l) {
                randomLongsSpliterator = null;
            } else {
                this.index = l2;
                RandomLongsSpliterator randomLongsSpliterator2 = new RandomLongsSpliterator(l, this.index, this.origin, this.bound);
                randomLongsSpliterator = randomLongsSpliterator2;
            }
            return randomLongsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            if (longConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                longConsumer.accept(ThreadLocalRandom.current().internalNextLong(this.origin, this.bound));
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            if (longConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                this.index = l2;
                long l3 = this.origin;
                long l4 = this.bound;
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                do {
                    longConsumer.accept(threadLocalRandom.internalNextLong(l3, l4));
                } while (++l < l2);
            }
        }
    }
}

