/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Objects;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private Type[] actualTypeArguments;
    private Class<?> rawType;
    private Type ownerType;

    private ParameterizedTypeImpl(Class<?> clazz, Type[] typeArray, Type clazz2) {
        this.actualTypeArguments = typeArray;
        this.rawType = clazz;
        this.ownerType = clazz2 != null ? clazz2 : clazz.getDeclaringClass();
        this.validateConstructorArguments();
    }

    private void validateConstructorArguments() {
        TypeVariable<Class<?>>[] typeVariableArray = this.rawType.getTypeParameters();
        if (typeVariableArray.length != this.actualTypeArguments.length) {
            throw new MalformedParameterizedTypeException();
        }
        for (int i = 0; i < this.actualTypeArguments.length; ++i) {
        }
    }

    public static ParameterizedTypeImpl make(Class<?> clazz, Type[] typeArray, Type type) {
        return new ParameterizedTypeImpl(clazz, typeArray, type);
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object object) {
        if (object instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)object;
            if (this == parameterizedType) {
                return true;
            }
            Type type = parameterizedType.getOwnerType();
            Type type2 = parameterizedType.getRawType();
            return Objects.equals(this.ownerType, type) && Objects.equals(this.rawType, type2) && Arrays.equals(this.actualTypeArguments, parameterizedType.getActualTypeArguments());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.ownerType != null) {
            if (this.ownerType instanceof Class) {
                stringBuilder.append(((Class)this.ownerType).getName());
            } else {
                stringBuilder.append(this.ownerType.toString());
            }
            stringBuilder.append(".");
            if (this.ownerType instanceof ParameterizedTypeImpl) {
                stringBuilder.append(this.rawType.getName().replace(((ParameterizedTypeImpl)this.ownerType).rawType.getName() + "$", ""));
            } else {
                stringBuilder.append(this.rawType.getName());
            }
        } else {
            stringBuilder.append(this.rawType.getName());
        }
        if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
            stringBuilder.append("<");
            boolean bl = true;
            for (Type type : this.actualTypeArguments) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(type.getTypeName());
                bl = false;
            }
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }
}

