/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.dispatch;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.client.WSPortInfo;
import com.sun.xml.internal.ws.api.message.AddressingUtils;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.AsyncInvoker;
import com.sun.xml.internal.ws.client.AsyncResponseImpl;
import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.ResponseContext;
import com.sun.xml.internal.ws.client.ResponseContextReceiver;
import com.sun.xml.internal.ws.client.Stub;
import com.sun.xml.internal.ws.client.WSServiceDelegate;
import com.sun.xml.internal.ws.client.dispatch.RESTSourceDispatch;
import com.sun.xml.internal.ws.client.dispatch.SOAPSourceDispatch;
import com.sun.xml.internal.ws.encoding.soap.DeserializationException;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.message.AttachmentSetImpl;
import com.sun.xml.internal.ws.message.DataHandlerAttachment;
import com.sun.xml.internal.ws.resources.DispatchMessages;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

public abstract class DispatchImpl<T>
extends Stub
implements Dispatch<T> {
    private static final Logger LOGGER = Logger.getLogger(DispatchImpl.class.getName());
    final Service.Mode mode;
    final SOAPVersion soapVersion;
    final boolean allowFaultResponseMsg;
    static final long AWAIT_TERMINATION_TIME = 800L;
    static final String HTTP_REQUEST_METHOD_GET = "GET";
    static final String HTTP_REQUEST_METHOD_POST = "POST";
    static final String HTTP_REQUEST_METHOD_PUT = "PUT";

    @Deprecated
    protected DispatchImpl(QName qName, Service.Mode mode, WSServiceDelegate wSServiceDelegate, Tube tube, BindingImpl bindingImpl, @Nullable WSEndpointReference wSEndpointReference) {
        super(qName, wSServiceDelegate, tube, bindingImpl, wSServiceDelegate.getWsdlService() != null ? wSServiceDelegate.getWsdlService().get(qName) : null, wSServiceDelegate.getEndpointAddress(qName), wSEndpointReference);
        this.mode = mode;
        this.soapVersion = bindingImpl.getSOAPVersion();
        this.allowFaultResponseMsg = false;
    }

    protected DispatchImpl(WSPortInfo wSPortInfo, Service.Mode mode, BindingImpl bindingImpl, @Nullable WSEndpointReference wSEndpointReference) {
        this(wSPortInfo, mode, bindingImpl, wSEndpointReference, false);
    }

    protected DispatchImpl(WSPortInfo wSPortInfo, Service.Mode mode, BindingImpl bindingImpl, @Nullable WSEndpointReference wSEndpointReference, boolean bl) {
        this(wSPortInfo, mode, bindingImpl, null, wSEndpointReference, bl);
    }

    protected DispatchImpl(WSPortInfo wSPortInfo, Service.Mode mode, BindingImpl bindingImpl, Tube tube, @Nullable WSEndpointReference wSEndpointReference, boolean bl) {
        super(wSPortInfo, bindingImpl, tube, wSPortInfo.getEndpointAddress(), wSEndpointReference);
        this.mode = mode;
        this.soapVersion = bindingImpl.getSOAPVersion();
        this.allowFaultResponseMsg = bl;
    }

    protected DispatchImpl(WSPortInfo wSPortInfo, Service.Mode mode, Tube tube, BindingImpl bindingImpl, @Nullable WSEndpointReference wSEndpointReference, boolean bl) {
        super(wSPortInfo, bindingImpl, tube, wSPortInfo.getEndpointAddress(), wSEndpointReference);
        this.mode = mode;
        this.soapVersion = bindingImpl.getSOAPVersion();
        this.allowFaultResponseMsg = bl;
    }

    abstract Packet createPacket(T var1);

    abstract T toReturnValue(Packet var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Response<T> invokeAsync(T t) {
        Container container = ContainerResolver.getDefault().enterContainer(this.owner.getContainer());
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                this.dumpParam(t, "invokeAsync(T)");
            }
            DispatchAsyncInvoker dispatchAsyncInvoker = new DispatchAsyncInvoker(t);
            AsyncResponseImpl asyncResponseImpl = new AsyncResponseImpl((Runnable)dispatchAsyncInvoker, null);
            dispatchAsyncInvoker.setReceiver(asyncResponseImpl);
            asyncResponseImpl.run();
            AsyncResponseImpl asyncResponseImpl2 = asyncResponseImpl;
            return asyncResponseImpl2;
        }
        finally {
            ContainerResolver.getDefault().exitContainer(container);
        }
    }

    private void dumpParam(T t, String string) {
        if (t instanceof Packet) {
            Packet packet = (Packet)t;
            if (LOGGER.isLoggable(Level.FINE)) {
                AddressingVersion addressingVersion = this.getBinding().getAddressingVersion();
                SOAPVersion sOAPVersion = this.getBinding().getSOAPVersion();
                String string2 = addressingVersion != null && packet.getMessage() != null ? AddressingUtils.getAction(packet.getMessage().getHeaders(), addressingVersion, sOAPVersion) : null;
                String string3 = addressingVersion != null && packet.getMessage() != null ? AddressingUtils.getMessageID(packet.getMessage().getHeaders(), addressingVersion, sOAPVersion) : null;
                LOGGER.fine("In DispatchImpl." + string + " for message with action: " + string2 + " and msg ID: " + string3 + " msg: " + packet.getMessage());
                if (packet.getMessage() == null) {
                    LOGGER.fine("Dispatching null message for action: " + string2 + " and msg ID: " + string3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Future<?> invokeAsync(T t, AsyncHandler<T> asyncHandler) {
        Container container = ContainerResolver.getDefault().enterContainer(this.owner.getContainer());
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                this.dumpParam(t, "invokeAsync(T, AsyncHandler<T>)");
            }
            DispatchAsyncInvoker dispatchAsyncInvoker = new DispatchAsyncInvoker(t);
            AsyncResponseImpl<T> asyncResponseImpl = new AsyncResponseImpl<T>((Runnable)dispatchAsyncInvoker, asyncHandler);
            dispatchAsyncInvoker.setReceiver(asyncResponseImpl);
            dispatchAsyncInvoker.setNonNullAsyncHandlerGiven(asyncHandler != null);
            asyncResponseImpl.run();
            AsyncResponseImpl<T> asyncResponseImpl2 = asyncResponseImpl;
            return asyncResponseImpl2;
        }
        finally {
            ContainerResolver.getDefault().exitContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T doInvoke(T t, RequestContext requestContext, ResponseContextReceiver responseContextReceiver) {
        Packet packet = null;
        try {
            Packet packet2;
            try {
                DispatchImpl.checkNullAllowed(t, requestContext, this.binding, this.mode);
                packet2 = this.createPacket(t);
                packet2.setState(Packet.State.ClientRequest);
                this.resolveEndpointAddress(packet2, requestContext);
                this.setProperties(packet2, true);
                packet = this.process(packet2, requestContext, responseContextReceiver);
                Message message = packet.getMessage();
                if (message != null && message.isFault() && !this.allowFaultResponseMsg) {
                    SOAPFaultBuilder sOAPFaultBuilder = SOAPFaultBuilder.create(message);
                    throw (SOAPFaultException)sOAPFaultBuilder.createException(null);
                }
            }
            catch (JAXBException jAXBException) {
                throw new DeserializationException(DispatchMessages.INVALID_RESPONSE_DESERIALIZATION(), new Object[]{jAXBException});
            }
            catch (WebServiceException webServiceException) {
                throw webServiceException;
            }
            catch (Throwable throwable) {
                throw new WebServiceException(throwable);
            }
            packet2 = this.toReturnValue(packet);
            return (T)packet2;
        }
        finally {
            if (packet != null && packet.transportBackChannel != null) {
                packet.transportBackChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T invoke(T t) {
        Container container = ContainerResolver.getDefault().enterContainer(this.owner.getContainer());
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                this.dumpParam(t, "invoke(T)");
            }
            T t2 = this.doInvoke(t, this.requestContext, this);
            return t2;
        }
        finally {
            ContainerResolver.getDefault().exitContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invokeOneWay(T t) {
        Container container = ContainerResolver.getDefault().enterContainer(this.owner.getContainer());
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                this.dumpParam(t, "invokeOneWay(T)");
            }
            try {
                DispatchImpl.checkNullAllowed(t, this.requestContext, this.binding, this.mode);
                Packet packet = this.createPacket(t);
                packet.setState(Packet.State.ClientRequest);
                this.setProperties(packet, false);
                this.process(packet, this.requestContext, this);
            }
            catch (WebServiceException webServiceException) {
                throw webServiceException;
            }
            catch (Throwable throwable) {
                throw new WebServiceException(throwable);
            }
        }
        finally {
            ContainerResolver.getDefault().exitContainer(container);
        }
    }

    void setProperties(Packet packet, boolean bl) {
        packet.expectReply = bl;
    }

    static boolean isXMLHttp(@NotNull WSBinding wSBinding) {
        return wSBinding.getBindingId().equals(BindingID.XML_HTTP);
    }

    static boolean isPAYLOADMode(@NotNull Service.Mode mode) {
        return mode == Service.Mode.PAYLOAD;
    }

    static void checkNullAllowed(@Nullable Object object, RequestContext requestContext, WSBinding wSBinding, Service.Mode mode) {
        if (object != null) {
            return;
        }
        if (DispatchImpl.isXMLHttp(wSBinding)) {
            if (DispatchImpl.methodNotOk(requestContext)) {
                throw new WebServiceException(DispatchMessages.INVALID_NULLARG_XMLHTTP_REQUEST_METHOD(HTTP_REQUEST_METHOD_POST, HTTP_REQUEST_METHOD_GET));
            }
        } else if (mode == Service.Mode.MESSAGE) {
            throw new WebServiceException(DispatchMessages.INVALID_NULLARG_SOAP_MSGMODE(mode.name(), Service.Mode.PAYLOAD.toString()));
        }
    }

    static boolean methodNotOk(@NotNull RequestContext requestContext) {
        String string = (String)requestContext.get("javax.xml.ws.http.request.method");
        String string2 = string == null ? HTTP_REQUEST_METHOD_POST : string;
        return HTTP_REQUEST_METHOD_POST.equalsIgnoreCase(string2) || HTTP_REQUEST_METHOD_PUT.equalsIgnoreCase(string2);
    }

    public static void checkValidSOAPMessageDispatch(WSBinding wSBinding, Service.Mode mode) {
        if (DispatchImpl.isXMLHttp(wSBinding)) {
            throw new WebServiceException(DispatchMessages.INVALID_SOAPMESSAGE_DISPATCH_BINDING("http://www.w3.org/2004/08/wsdl/http", "http://schemas.xmlsoap.org/wsdl/soap/http or http://www.w3.org/2003/05/soap/bindings/HTTP/"));
        }
        if (DispatchImpl.isPAYLOADMode(mode)) {
            throw new WebServiceException(DispatchMessages.INVALID_SOAPMESSAGE_DISPATCH_MSGMODE(mode.name(), Service.Mode.MESSAGE.toString()));
        }
    }

    public static void checkValidDataSourceDispatch(WSBinding wSBinding, Service.Mode mode) {
        if (!DispatchImpl.isXMLHttp(wSBinding)) {
            throw new WebServiceException(DispatchMessages.INVALID_DATASOURCE_DISPATCH_BINDING("SOAP/HTTP", "http://www.w3.org/2004/08/wsdl/http"));
        }
        if (DispatchImpl.isPAYLOADMode(mode)) {
            throw new WebServiceException(DispatchMessages.INVALID_DATASOURCE_DISPATCH_MSGMODE(mode.name(), Service.Mode.MESSAGE.toString()));
        }
    }

    @Override
    @NotNull
    public final QName getPortName() {
        return this.portname;
    }

    void resolveEndpointAddress(@NotNull Packet packet, @NotNull RequestContext requestContext) {
        boolean bl = packet.packetTakesPriorityOverRequestContext;
        String string = bl && packet.endpointAddress != null ? packet.endpointAddress.toString() : (String)requestContext.get("javax.xml.ws.service.endpoint.address");
        if (string == null) {
            if (packet.endpointAddress == null) {
                throw new WebServiceException(DispatchMessages.INVALID_NULLARG_URI());
            }
            string = packet.endpointAddress.toString();
        }
        String string2 = null;
        String string3 = null;
        if (bl && packet.invocationProperties.get("javax.xml.ws.http.request.pathinfo") != null) {
            string2 = (String)packet.invocationProperties.get("javax.xml.ws.http.request.pathinfo");
        } else if (requestContext.get("javax.xml.ws.http.request.pathinfo") != null) {
            string2 = (String)requestContext.get("javax.xml.ws.http.request.pathinfo");
        }
        if (bl && packet.invocationProperties.get("javax.xml.ws.http.request.querystring") != null) {
            string3 = (String)packet.invocationProperties.get("javax.xml.ws.http.request.querystring");
        } else if (requestContext.get("javax.xml.ws.http.request.querystring") != null) {
            string3 = (String)requestContext.get("javax.xml.ws.http.request.querystring");
        }
        if (string2 != null || string3 != null) {
            string2 = DispatchImpl.checkPath(string2);
            string3 = DispatchImpl.checkQuery(string3);
            if (string != null) {
                try {
                    URI uRI = new URI(string);
                    string = this.resolveURI(uRI, string2, string3);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new WebServiceException(DispatchMessages.INVALID_URI(string));
                }
            }
        }
        requestContext.put("javax.xml.ws.service.endpoint.address", string);
    }

    @NotNull
    protected String resolveURI(@NotNull URI uRI, @Nullable String string, @Nullable String string2) {
        Object object;
        Serializable serializable;
        String string3 = null;
        String string4 = null;
        if (string2 != null) {
            try {
                serializable = new URI(null, null, uRI.getPath(), string2, null);
                object = uRI.resolve((URI)serializable);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new WebServiceException(DispatchMessages.INVALID_QUERY_STRING(string2));
            }
            string3 = ((URI)object).getQuery();
            string4 = ((URI)object).getFragment();
        }
        object = string != null ? string : uRI.getPath();
        try {
            serializable = new StringBuilder();
            if (object != null) {
                ((StringBuilder)serializable).append((String)object);
            }
            if (string3 != null) {
                ((StringBuilder)serializable).append("?");
                ((StringBuilder)serializable).append(string3);
            }
            if (string4 != null) {
                ((StringBuilder)serializable).append("#");
                ((StringBuilder)serializable).append(string4);
            }
            return new URL(uRI.toURL(), ((StringBuilder)serializable).toString()).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new WebServiceException(DispatchMessages.INVALID_URI_RESOLUTION(object));
        }
    }

    private static String checkPath(@Nullable String string) {
        return string == null || string.startsWith("/") ? string : "/" + string;
    }

    private static String checkQuery(@Nullable String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(63) == 0) {
            throw new WebServiceException(DispatchMessages.INVALID_QUERY_LEADING_CHAR(string));
        }
        return string;
    }

    protected AttachmentSet setOutboundAttachments() {
        HashMap hashMap = (HashMap)this.getRequestContext().get("javax.xml.ws.binding.attachments.outbound");
        if (hashMap != null) {
            ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
            for (Map.Entry entry : hashMap.entrySet()) {
                DataHandlerAttachment dataHandlerAttachment = new DataHandlerAttachment((String)entry.getKey(), (DataHandler)entry.getValue());
                arrayList.add(dataHandlerAttachment);
            }
            return new AttachmentSetImpl(arrayList);
        }
        return new AttachmentSetImpl();
    }

    @Override
    public void setOutboundHeaders(Object ... objectArray) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static Dispatch<Source> createSourceDispatch(QName qName, Service.Mode mode, WSServiceDelegate wSServiceDelegate, Tube tube, BindingImpl bindingImpl, WSEndpointReference wSEndpointReference) {
        if (DispatchImpl.isXMLHttp(bindingImpl)) {
            return new RESTSourceDispatch(qName, mode, wSServiceDelegate, tube, bindingImpl, wSEndpointReference);
        }
        return new SOAPSourceDispatch(qName, mode, wSServiceDelegate, tube, bindingImpl, wSEndpointReference);
    }

    public static Dispatch<Source> createSourceDispatch(WSPortInfo wSPortInfo, Service.Mode mode, BindingImpl bindingImpl, WSEndpointReference wSEndpointReference) {
        if (DispatchImpl.isXMLHttp(bindingImpl)) {
            return new RESTSourceDispatch(wSPortInfo, mode, bindingImpl, wSEndpointReference);
        }
        return new SOAPSourceDispatch(wSPortInfo, mode, bindingImpl, wSEndpointReference);
    }

    private class DispatchAsyncInvoker
    extends AsyncInvoker {
        private final T param;
        private final RequestContext rc;

        DispatchAsyncInvoker(T t) {
            this.rc = DispatchImpl.this.requestContext.copy();
            this.param = t;
        }

        @Override
        public void do_run() {
            SOAPVersion sOAPVersion;
            AddressingVersion addressingVersion;
            DispatchImpl.checkNullAllowed(this.param, this.rc, DispatchImpl.this.binding, DispatchImpl.this.mode);
            Packet packet = DispatchImpl.this.createPacket(this.param);
            packet.setState(Packet.State.ClientRequest);
            packet.nonNullAsyncHandlerGiven = this.nonNullAsyncHandlerGiven;
            DispatchImpl.this.resolveEndpointAddress(packet, this.rc);
            DispatchImpl.this.setProperties(packet, true);
            AddressingVersion addressingVersion2 = null;
            SOAPVersion sOAPVersion2 = null;
            if (LOGGER.isLoggable(Level.FINE)) {
                addressingVersion = DispatchImpl.this.getBinding().getAddressingVersion();
                sOAPVersion = DispatchImpl.this.getBinding().getSOAPVersion();
                addressingVersion2 = addressingVersion != null && packet.getMessage() != null ? AddressingUtils.getAction(packet.getMessage().getHeaders(), addressingVersion, sOAPVersion) : null;
                sOAPVersion2 = addressingVersion != null && packet.getMessage() != null ? AddressingUtils.getMessageID(packet.getMessage().getHeaders(), addressingVersion, sOAPVersion) : null;
                LOGGER.fine("In DispatchAsyncInvoker.do_run for async message with action: " + (String)((Object)addressingVersion2) + " and msg ID: " + (String)((Object)sOAPVersion2));
            }
            addressingVersion = addressingVersion2;
            sOAPVersion = sOAPVersion2;
            Fiber.CompletionCallback completionCallback = new Fiber.CompletionCallback((String)((Object)addressingVersion), (String)((Object)sOAPVersion)){
                final /* synthetic */ String val$actionUse;
                final /* synthetic */ String val$msgIdUse;
                {
                    this.val$actionUse = string;
                    this.val$msgIdUse = string2;
                }

                @Override
                public void onCompletion(@NotNull Packet packet) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Done with processAsync in DispatchAsyncInvoker.do_run, and setting response for async message with action: " + this.val$actionUse + " and msg ID: " + this.val$msgIdUse);
                    }
                    Message message = packet.getMessage();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Done with processAsync in DispatchAsyncInvoker.do_run, and setting response for async message with action: " + this.val$actionUse + " and msg ID: " + this.val$msgIdUse + " msg: " + message);
                    }
                    try {
                        if (message != null && message.isFault() && !DispatchImpl.this.allowFaultResponseMsg) {
                            SOAPFaultBuilder sOAPFaultBuilder = SOAPFaultBuilder.create(message);
                            throw (SOAPFaultException)sOAPFaultBuilder.createException(null);
                        }
                        DispatchAsyncInvoker.this.responseImpl.setResponseContext(new ResponseContext(packet));
                        DispatchAsyncInvoker.this.responseImpl.set(DispatchImpl.this.toReturnValue(packet), null);
                    }
                    catch (JAXBException jAXBException) {
                        DispatchAsyncInvoker.this.responseImpl.set(null, new DeserializationException(DispatchMessages.INVALID_RESPONSE_DESERIALIZATION(), new Object[]{jAXBException}));
                    }
                    catch (WebServiceException webServiceException) {
                        DispatchAsyncInvoker.this.responseImpl.set(null, webServiceException);
                    }
                    catch (Throwable throwable) {
                        DispatchAsyncInvoker.this.responseImpl.set(null, new WebServiceException(throwable));
                    }
                }

                @Override
                public void onCompletion(@NotNull Throwable throwable) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Done with processAsync in DispatchAsyncInvoker.do_run, and setting response for async message with action: " + this.val$actionUse + " and msg ID: " + this.val$msgIdUse + " Throwable: " + throwable.toString());
                    }
                    if (throwable instanceof WebServiceException) {
                        DispatchAsyncInvoker.this.responseImpl.set(null, throwable);
                    } else {
                        DispatchAsyncInvoker.this.responseImpl.set(null, new WebServiceException(throwable));
                    }
                }
            };
            DispatchImpl.this.processAsync(this.responseImpl, packet, this.rc, completionCallback);
        }
    }

    private class Invoker
    implements Callable {
        private final T param;
        private final RequestContext rc;
        private ResponseContextReceiver receiver;

        Invoker(T t) {
            this.rc = DispatchImpl.this.requestContext.copy();
            this.param = t;
        }

        public T call() throws Exception {
            if (LOGGER.isLoggable(Level.FINE)) {
                DispatchImpl.this.dumpParam(this.param, "call()");
            }
            return DispatchImpl.this.doInvoke(this.param, this.rc, this.receiver);
        }

        void setReceiver(ResponseContextReceiver responseContextReceiver) {
            this.receiver = responseContextReceiver;
        }
    }
}

